/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.core.object;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.IIdentifiableApiObject;
import bsc.api.IMetaInformation;
import bsc.api.basic.container.ObjectContainer;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ASensor;
import bsc.api.basic.model.ISensor;
import bsc.api.transport.TransmissionObject;
import bsc.api.transport.result.ObjectResult;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.notification.objects.AddDeviceOffers;
import bsc.sdk.api.notification.objects.AddMetaData;
import bsc.sdk.api.notification.objects.AddSensorOffers;
import bsc.sdk.api.objects.AObjectProcessor;
import bsc.sdk.api.objects.IProcessorExecutor;
import bsc.sdk.api.objects.manager.ObjectIdentifier;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.group.Permission;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectProcessor
extends AObjectProcessor {
    private static Logger logger = LoggerFactory.getLogger(ObjectProcessor.class);
    private static IProcessorExecutor executor = new IProcessorExecutor(){

        @Override
        public void processObject(UserCredentialIdentifier user, IApiObject object) {
            long start = System.currentTimeMillis();
            logger.trace("Process object: " + object.getClass().getName());
            if (object instanceof IIdentifiableApiObject) {
                Environment env = user.getEnvironment();
                EnumSet<Permission> userPermissions = user.getEffektivePermissions((ObjectIdentifier)env.getObjectManager().getIdentifierInstance((IIdentifiableApiObject)object));
                if (object instanceof ASensor) {
                    env.getApplication().publishObject(Enumerations.OBJECT_BUS_TAGS.PUBLISH_NOTIFICATION, (Object)new AddSensorOffers((ISensor)object, userPermissions, user));
                } else if (object instanceof ADevice) {
                    env.getApplication().publishObject(Enumerations.OBJECT_BUS_TAGS.PUBLISH_NOTIFICATION, (Object)new AddDeviceOffers((ADevice)object, userPermissions, user));
                    ADevice device = (ADevice)object;
                    for (ISensor sensor : device.getSensors()) {
                        this.processObject(user, sensor);
                    }
                }
                if (object instanceof IMetaInformation) {
                    IMetaInformation info = (IMetaInformation)((Object)object);
                    env.getApplication().publishObject(Enumerations.OBJECT_BUS_TAGS.PUBLISH_NOTIFICATION, (Object)new AddMetaData(info, user));
                }
            } else if (object instanceof ObjectContainer) {
                ObjectContainer container = (ObjectContainer)object;
                for (IIdentifiableApiObject obj : container.getObjects()) {
                    this.processObject(user, obj);
                }
            } else if (object instanceof ObjectResult) {
                ObjectResult result = (ObjectResult)object;
                IApiObject iApiObject = result.getObject();
                if (iApiObject instanceof ObjectContainer || iApiObject instanceof IIdentifiableApiObject) {
                    this.processObject(user, iApiObject);
                }
            } else if (object instanceof TransmissionObject) {
                TransmissionObject transmissionObject = (TransmissionObject)object;
                this.processObject(user, transmissionObject.getObject());
            }
            logger.trace(object.getClass().getName() + " processed after " + (System.currentTimeMillis() - start) + " ms");
        }
    };

    public static IProcessorExecutor getExecutor() {
        return executor;
    }

    public static void setExecutor(IProcessorExecutor executor) {
        ObjectProcessor.executor = executor;
    }

    public ObjectProcessor(Environment environment) {
        super(environment, executor);
    }

    @Override
    public int getExecutePosition() {
        return 10;
    }
}

