/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.core.command.executor;

import bsc.api.Enumerations;
import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.container.ObjectContainer;
import bsc.api.basic.container.TYPE;
import bsc.api.modules.IModuleClass;
import bsc.api.modules.core.commands.GetAllObjectsCommand;
import bsc.api.transport.result.FailResult;
import bsc.api.transport.result.ObjectResult;
import bsc.api.transport.result.OkResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.core.command.ACoreExecutor;
import bsc.sdk.api.handler.command.Executable;
import bsc.sdk.api.objects.manager.ObjectIdentifier;
import bsc.sdk.api.transceiver.controller.impl.TransceiverController;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.api.transceiver.transmission.FutureTransmission;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.session.ISession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class GetAllObjectsExecutor
extends ACoreExecutor<GetAllObjectsCommand> {
    private static Executable<GetAllObjectsCommand> executable = new CommandExecutor();

    public GetAllObjectsExecutor(Environment enviromentSettings) {
        super(executable, enviromentSettings);
    }

    public static void setExecutable(Executable<GetAllObjectsCommand> executable) {
        GetAllObjectsExecutor.executable = executable;
    }

    public static Executable<GetAllObjectsCommand> getExecutable() {
        return executable;
    }

    public static class CommandExecutor
    extends Executable<GetAllObjectsCommand> {
        private Set<IIdentifiableApiObject> gatherObjects(TransceiverIdentifier identifier, UserCredentialIdentifier userCredentialIdentifier) {
            long start = System.currentTimeMillis();
            this.logger.trace("Start gathering of objects...");
            Environment environment = identifier.getEnvironment();
            HashSet<IIdentifiableApiObject> objects = new HashSet<IIdentifiableApiObject>();
            EnumSet<ObjectIdentifier.OBJECT_TYPE> types = EnumSet.allOf(ObjectIdentifier.OBJECT_TYPE.class);
            types.remove((Object)ObjectIdentifier.OBJECT_TYPE.SENSOR);
            Set<IIdentifiableApiObject> accessibleObjects = environment.getObjectManager().getObjectsForUser(userCredentialIdentifier, types, false);
            this.logger.trace(accessibleObjects.size() + " accessible objects after " + (System.currentTimeMillis() - start) + " ms");
            for (IIdentifiableApiObject iIdentifiableApiObject : accessibleObjects) {
                String objectExtensionID = null;
                if (!IModuleClass.class.isAssignableFrom(iIdentifiableApiObject.getClass()) || (objectExtensionID = environment.getExtensionManager().getObjectExtensionID((IModuleClass)((Object)iIdentifiableApiObject))) == null || !environment.getExtensionManager().isSubscribedFor(identifier, objectExtensionID)) continue;
                objects.add(iIdentifiableApiObject);
            }
            this.logger.trace("Finished gathering objects. Takes: " + (System.currentTimeMillis() - start) + " ms");
            return objects;
        }

        @Override
        public Result execute(final TransceiverIdentifier identifier, GetAllObjectsCommand command) {
            long startTimestamp = System.currentTimeMillis();
            final Environment environment = identifier.getEnvironment();
            final TransceiverController controller = identifier.getControllerInstance();
            ISession session = controller.getCurrentSessionID().getObjectInstance();
            final UserCredentialIdentifier userCredentialIdentifier = identifier.getUserCredentialIdentifier();
            Result result = null;
            if (session != null) {
                final int incrementalSize = command.getIncrementalSize();
                if (incrementalSize > 0) {
                    final long start = System.currentTimeMillis();
                    this.logger.trace("Incremental GetAllObjectsCommand started...");
                    Runnable worker = new Runnable(){

                        @Override
                        public void run() {
                            Set objects = CommandExecutor.this.gatherObjects(identifier, userCredentialIdentifier);
                            int objectCount = objects.size();
                            int sequenceLength = (int)Math.ceil((double)objectCount / (double)incrementalSize);
                            String sequenzId = environment.getIdPoolManager().getIdFromPool("objContSeq");
                            ArrayList tmpList = new ArrayList(objects);
                            int listIndex = 0;
                            for (int i = 1; i <= sequenceLength; ++i) {
                                int sequenceObjectCount;
                                long startSeq = System.currentTimeMillis();
                                CommandExecutor.this.logger.trace("Create sequence " + i + " from " + sequenceLength + ". | " + sequenzId);
                                ObjectContainer container = new ObjectContainer();
                                container.setType(TYPE.FULL_INCREMENTAL);
                                container.setSequenceId(sequenzId);
                                container.setSequenceLength(sequenceLength);
                                container.setSequenceCount(i);
                                for (sequenceObjectCount = 0; sequenceObjectCount < incrementalSize; ++sequenceObjectCount) {
                                    container.addObject(tmpList.get(listIndex));
                                    if (++listIndex < objectCount) continue;
                                }
                                CommandExecutor.this.logger.trace(sequenceObjectCount + " objects attached to sequence. Sending sequence now...");
                                FutureTransmission ft = controller.sendObject(container);
                                ft.getTransmissionIdentifier(true);
                                CommandExecutor.this.logger.trace("Sequence " + i + " from " + sequenceLength + " send.  Takes: " + (System.currentTimeMillis() - startSeq) + " ms | " + sequenzId);
                            }
                            CommandExecutor.this.logger.trace("Finished sending incremental GetAllObjectsCommand. Takes: " + (System.currentTimeMillis() - start) + " ms");
                        }
                    };
                    environment.getApplication().getExecutorServiceBackgroundTasks().execute(worker);
                    result = new OkResult();
                } else {
                    result = new ObjectResult(new ObjectContainer((Collection<IIdentifiableApiObject>)this.gatherObjects(identifier, userCredentialIdentifier)));
                }
            } else {
                result = new FailResult(Enumerations.ErrorType.SESSION_NOT_FOUND);
            }
            this.logger.trace("Get all objects takes: " + (System.currentTimeMillis() - startTimestamp) + " ms");
            return result;
        }
    }
}

