/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.core.command;

import bsc.api.Enumerations;
import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.commands.Command;
import bsc.api.basic.container.ObjectContainer;
import bsc.api.transport.result.FailResult;
import bsc.api.transport.result.ObjectResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.handler.command.AExecutor;
import bsc.sdk.api.handler.command.Executable;
import bsc.sdk.api.transceiver.controller.impl.TransceiverController;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.session.ISession;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AGetObjectsByTypeExecutor<T extends Command>
extends AExecutor<T> {
    protected Set<Class<? extends IIdentifiableApiObject>> objectClasses = new HashSet<Class<? extends IIdentifiableApiObject>>();

    public AGetObjectsByTypeExecutor(Enumerations.EXTENSION_ID extensionId, Environment environment, Class<? extends IIdentifiableApiObject> ... objectClasses) {
        this(extensionId.name(), null, environment, objectClasses);
    }

    public AGetObjectsByTypeExecutor(Enumerations.EXTENSION_ID extensionId, Executable<T> executable, Environment environment, Class<? extends IIdentifiableApiObject> ... objectClasses) {
        this(extensionId.name(), executable, environment, objectClasses);
    }

    public AGetObjectsByTypeExecutor(String extensionId, Executable<T> executable, Environment environment, final Class<? extends IIdentifiableApiObject> ... objectClasses) {
        super(extensionId, executable != null ? executable : new Executable<T>(){

            @Override
            public Result execute(TransceiverIdentifier identifier, T command) {
                return AGetObjectsByTypeExecutor.produceResult(identifier, objectClasses);
            }
        }, environment);
    }

    protected static void filterObjects(Set<IIdentifiableApiObject> devices, Class<? extends IIdentifiableApiObject> ... objectClasses) {
        if (devices != null && objectClasses != null) {
            Iterator<IIdentifiableApiObject> itr = devices.iterator();
            while (itr.hasNext()) {
                if (AGetObjectsByTypeExecutor.isRequestedObject(itr.next(), objectClasses)) continue;
                itr.remove();
            }
        }
    }

    protected static boolean isRequestedObject(IIdentifiableApiObject object, Class<? extends IIdentifiableApiObject> ... objectClasses) {
        if (object != null && objectClasses != null) {
            for (Class<? extends IIdentifiableApiObject> clazz : objectClasses) {
                if (!clazz.isAssignableFrom(object.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    protected static Result produceResult(TransceiverIdentifier identifier, Class<? extends IIdentifiableApiObject> ... objectClasses) {
        if (objectClasses == null) {
            return new FailResult(Enumerations.ErrorType.EXCEPTION);
        }
        TransceiverController controller = identifier.getControllerInstance();
        ISession session = controller.getCurrentSessionID().getObjectInstance();
        UserCredentialIdentifier userCredentialIdentifier = identifier.getUserCredentialIdentifier();
        if (session != null) {
            Set<IIdentifiableApiObject> objects = userCredentialIdentifier.getAccessibleObjects();
            AGetObjectsByTypeExecutor.filterObjects(objects, objectClasses);
            return new ObjectResult(new ObjectContainer((Collection<IIdentifiableApiObject>)objects));
        }
        return new FailResult(Enumerations.ErrorType.SESSION_NOT_FOUND);
    }
}

