/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.camera.notification;

import bsc.api.basic.model.ADevice;
import bsc.api.modules.bsc.model.ServerInterface;
import bsc.api.modules.camera.commands.offer.GetCamerasOffer;
import bsc.api.modules.camera.commands.offer.MoveCameraOffer;
import bsc.api.modules.camera.commands.offer.StartStreamOffer;
import bsc.api.modules.camera.commands.offer.StopStreamOffer;
import bsc.api.modules.camera.model.Camera;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.camera.notification.ACameraNotification;
import bsc.sdk.api.extension.notification.AObjectNotificationListener;
import bsc.sdk.api.notification.ANotificationExecutor;
import bsc.sdk.api.notification.objects.AddDeviceOffers;
import bsc.sdk.api.user.group.Permission;
import java.util.EnumSet;

public class AddDeviceOffersHandler
extends ACameraNotification<AddDeviceOffers> {
    private static ANotificationExecutor<AddDeviceOffers> executor = new ANotificationExecutor<AddDeviceOffers>(){

        @Override
        public void execute(AObjectNotificationListener<AddDeviceOffers> parent, AddDeviceOffers object) {
            ADevice device = object.getDevice();
            EnumSet<Permission> rights = object.getPermissions();
            if (rights.contains((Object)Permission.VIEW_EXTENDED) && device instanceof Camera) {
                device.addCommandOffer(new StartStreamOffer());
                device.addCommandOffer(new StopStreamOffer());
                device.addCommandOffer(new MoveCameraOffer());
            } else if (device instanceof ServerInterface && rights.contains((Object)Permission.VIEW)) {
                device.addCommandOffer(new GetCamerasOffer());
            }
        }
    };

    public AddDeviceOffersHandler(Environment enviromentSettings) {
        super(executor, enviromentSettings);
    }

    public static ANotificationExecutor<AddDeviceOffers> getExecutor() {
        return executor;
    }

    public static void setExecutor(ANotificationExecutor<AddDeviceOffers> executor) {
        AddDeviceOffersHandler.executor = executor;
    }
}

