/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.bsc.object;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.modules.core.model.DeviceDeleted;
import bsc.api.modules.core.model.GroupDeleted;
import bsc.api.transport.result.OkResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.handler.IHandleExecutor;
import bsc.sdk.api.handler.object.AObjectHandler;
import bsc.sdk.api.objects.manager.DeviceIdentifier;
import bsc.sdk.api.objects.manager.GroupIdentifier;
import bsc.sdk.api.objects.manager.ObjectIdentifier;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;

public class ObjectHandler
extends AObjectHandler {
    private static IHandleExecutor executor = new IHandleExecutor(){

        @Override
        public Result doHandle(TransceiverIdentifier identifier, IApiObject object) {
            ObjectIdentifier objectIdentifier = null;
            if (object instanceof DeviceDeleted) {
                DeviceDeleted obj = (DeviceDeleted)object;
                objectIdentifier = (ObjectIdentifier)identifier.getEnvironment().getObjectManager().getIdentifierInstance(DeviceIdentifier.generateURI(obj.getDeviceID(), identifier.getEnvironment()));
            } else if (object instanceof GroupDeleted) {
                GroupDeleted obj = (GroupDeleted)object;
                objectIdentifier = (ObjectIdentifier)identifier.getEnvironment().getObjectManager().getIdentifierInstance(GroupIdentifier.generateURI(String.valueOf(obj.getGroupID()), identifier.getEnvironment()));
            }
            if (objectIdentifier != null) {
                objectIdentifier.deleteObject();
            }
            return new OkResult();
        }
    };

    public ObjectHandler(Environment environment) {
        super(Enumerations.EXTENSION_ID.BSC, environment, executor);
    }

    @Override
    public boolean isSupported(IApiObject object) {
        return object instanceof DeviceDeleted || object instanceof GroupDeleted;
    }

    public static IHandleExecutor getExecutor() {
        return executor;
    }

    public static void setExecutor(IHandleExecutor executor) {
        ObjectHandler.executor = executor;
    }
}

