/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension;

import bsc.api.Enumerations;
import bsc.api.basic.AMetaInformation;
import bsc.api.modules.IModuleClass;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.ExtensionIdentifier;
import bsc.sdk.api.extension.IExtension;
import bsc.sdk.api.extension.notification.IObjectNotificationListener;
import bsc.sdk.api.handler.IObjectHandler;
import bsc.sdk.api.handler.command.CommandHandler;
import bsc.sdk.api.objects.IObjectProcessor;
import bsc.sdk.api.transceiver.controller.IObjectValidator;
import bsc.sdk.tools.Tools;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AExtension
implements IExtension {
    protected final Logger logger;
    protected boolean internalExtension = false;
    protected boolean enabled = true;
    protected Enumerations.EXTENSION_ID extensionId;
    protected Environment environment;
    protected Set<IObjectNotificationListener> objectListener = new HashSet<IObjectNotificationListener>();
    protected Set<IObjectHandler> objectHandler = new HashSet<IObjectHandler>();
    protected Set<IObjectProcessor> objectProcessor = new HashSet<IObjectProcessor>();
    protected Set<IObjectValidator> objectValidator = new HashSet<IObjectValidator>();
    protected Map<String, String> extensionSettings = new HashMap<String, String>();
    protected Set<Class<? extends IModuleClass>> supportedModelObjects = new HashSet<Class<? extends IModuleClass>>();
    protected Set<Class<? extends IModuleClass>> supportedCommandObjects = new HashSet<Class<? extends IModuleClass>>();
    protected Set<Class<? extends IModuleClass>> supportedOfferObjects = new HashSet<Class<? extends IModuleClass>>();
    protected Set<Class<?>> metaInformationEnums = new HashSet();

    private AExtension() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public AExtension(Enumerations.EXTENSION_ID extensionID) {
        this();
        this.extensionId = Objects.requireNonNull(extensionID, "ExtensionId must not be null!");
    }

    public AExtension(String extensionId) {
        this();
        Enumerations.EXTENSION_ID extId = Enumerations.EXTENSION_ID.getByID(extensionId);
        if (extId == null) {
            Enumerations.EXTENSION_ID.CUSTOM.setId(extensionId, this.getClass());
            extId = Enumerations.EXTENSION_ID.getByID(extensionId);
        }
        this.extensionId = Objects.requireNonNull(extId, "ExtensionId must not be null!");
    }

    @Override
    public boolean isInternalExtension() {
        return this.internalExtension;
    }

    protected void setInternalExtension(boolean internalExtension) {
        this.internalExtension = internalExtension;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getExtensionId() {
        return this.extensionId.getId(this.getClass());
    }

    @Override
    public boolean init(Environment environment) {
        if (environment == null) {
            return false;
        }
        this.environment = environment;
        this.loadSupportedModuleClasses();
        this.loadDefaultObjectHandlers();
        this.loadDefaultObjectProcessors();
        this.loadDefaultObjectValidators();
        this.loadDefaultCommandHandlers();
        this.loadDefaultObjectNotificationListner();
        this._init();
        return this.environment.getExtensionManager().register(this);
    }

    @Override
    public Set<IObjectNotificationListener> getObjectListenerSet() {
        HashSet<IObjectNotificationListener> result = new HashSet<IObjectNotificationListener>();
        result.addAll(this.objectListener);
        return result;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    protected boolean addObjectListener(IObjectNotificationListener objectListener) {
        return this.objectListener.add(objectListener);
    }

    protected boolean removeNotifierClass(Class<?> clazz) {
        return this.objectListener.remove(clazz);
    }

    protected boolean addObjectHandler(IObjectHandler objectHandler) {
        return this.objectHandler.add(objectHandler);
    }

    protected boolean removeObjectHandler(IObjectHandler objectHandler) {
        return this.objectHandler.remove(objectHandler);
    }

    @Override
    public Set<IObjectHandler> getObjectHandlerSet() {
        return new HashSet<IObjectHandler>(this.objectHandler);
    }

    protected boolean addObjectProcessor(IObjectProcessor objectProcessor) {
        this.logger.trace("Add object processor: " + objectProcessor.getClass().getName());
        return this.objectProcessor.add(objectProcessor);
    }

    protected boolean removeObjectProcessor(IObjectProcessor objectProcessor) {
        this.logger.trace("Remove object processor: " + objectProcessor.getClass().getName());
        return this.objectProcessor.remove(objectProcessor);
    }

    @Override
    public Set<IObjectProcessor> getObjectProcessorSet() {
        return new HashSet<IObjectProcessor>(this.objectProcessor);
    }

    protected boolean addObjectValidator(IObjectValidator objectValidator) {
        this.logger.trace("Add object validator: " + objectValidator.getClass().getName());
        return this.objectValidator.add(objectValidator);
    }

    protected boolean removeObjectValidator(IObjectValidator objectValidator) {
        this.logger.trace("Remove object validator: " + objectValidator.getClass().getName());
        return this.objectValidator.remove(objectValidator);
    }

    @Override
    public Set<IObjectValidator> getObjectValidatorSet() {
        return new HashSet<IObjectValidator>(this.objectValidator);
    }

    protected void putExtensionSetting(String key, String value) {
        this.extensionSettings.put(key, value);
    }

    protected void putExtensionSetting(Enum<?> key, String value) {
        this.extensionSettings.put(key.name(), value);
    }

    public String getExtensionSetting(String key) {
        return this.extensionSettings.get(key);
    }

    public String getExtensionSetting(Enum<?> key) {
        return this.extensionSettings.get(key.name());
    }

    public static String getExtensionSettingFromMap(Enum<?> key, Map<String, String> map) {
        return map.get(key.name());
    }

    protected void removeExtensionSetting(Enum<?> key) {
        this.extensionSettings.remove(key.name());
    }

    protected int parseInt(String value) {
        int result = 0;
        try {
            if (value != null) {
                Integer.parseInt(value);
            }
        }
        catch (NumberFormatException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected void loadDefaultCommandHandlers() {
        List<Class<CommandHandler>> classes = Tools.getClasses(this.getClass().getPackage().getName() + ".command", CommandHandler.class);
        for (Class<CommandHandler> clazz : classes) {
            if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
            try {
                Constructor<CommandHandler> constructor = clazz.getConstructor(Environment.class);
                CommandHandler commandHandler = constructor.newInstance(this.getEnvironment());
                this.logger.trace("load " + commandHandler.getClass().getName());
                this.addObjectHandler(commandHandler);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.logger.trace("Failed to create instance for: " + clazz.getName(), (Throwable)e);
            }
        }
    }

    protected void loadDefaultObjectHandlers() {
        List<Class<IObjectHandler>> classes = Tools.getClasses(this.getClass().getPackage().getName() + ".object", IObjectHandler.class);
        for (Class<IObjectHandler> clazz : classes) {
            if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
            try {
                IObjectHandler objectHandler = clazz.getConstructor(Environment.class).newInstance(this.getEnvironment());
                this.logger.trace("load " + objectHandler.getClass().getName());
                this.addObjectHandler(objectHandler);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.logger.trace("Failed to create instance for: " + clazz.getName(), (Throwable)e);
            }
        }
    }

    protected void loadDefaultObjectProcessors() {
        List<Class<IObjectProcessor>> classes = Tools.getClasses(this.getClass().getPackage().getName() + ".object", IObjectProcessor.class);
        for (Class<IObjectProcessor> clazz : classes) {
            if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
            try {
                IObjectProcessor objectProcessor = clazz.getConstructor(Environment.class).newInstance(this.getEnvironment());
                this.logger.trace("load " + objectProcessor.getClass().getName());
                this.addObjectProcessor(objectProcessor);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.logger.trace("Failed to create instance for: " + clazz.getName(), (Throwable)e);
            }
        }
    }

    protected void loadDefaultObjectValidators() {
        List<Class<IObjectValidator>> classes = Tools.getClasses(this.getClass().getPackage().getName() + ".object", IObjectValidator.class);
        for (Class<IObjectValidator> clazz : classes) {
            if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
            try {
                IObjectValidator objectValidator = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.logger.trace("load " + objectValidator.getClass().getName());
                this.addObjectValidator(objectValidator);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.logger.trace("Failed to create instance for: " + clazz.getName(), (Throwable)e);
            }
        }
    }

    protected void loadDefaultObjectNotificationListner() {
        List<Class<IObjectNotificationListener>> classes = Tools.getClasses(this.getClass().getPackage().getName() + ".notification", IObjectNotificationListener.class);
        for (Class<IObjectNotificationListener> clazz : classes) {
            if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
            try {
                IObjectNotificationListener objectNotificationListener = clazz.getConstructor(Environment.class).newInstance(this.getEnvironment());
                this.logger.trace("load " + objectNotificationListener.getClass().getName());
                this.objectListener.add(objectNotificationListener);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.logger.trace("Failed to create instance for: " + clazz.getName(), (Throwable)e);
            }
        }
    }

    protected void loadSupportedModuleClasses() {
        this.supportedModelObjects = this.getSupportedObjects(IModuleClass.CLASS_TYPE.MODEL);
        this.supportedCommandObjects = this.getSupportedObjects(IModuleClass.CLASS_TYPE.COMMANDS);
        this.supportedOfferObjects = this.getSupportedObjects(IModuleClass.CLASS_TYPE.OFFER);
    }

    protected Set<Class<? extends IModuleClass>> getSupportedObjects(IModuleClass.CLASS_TYPE type) {
        Class<? extends IModuleClass> baseClass;
        HashSet<Class<? extends IModuleClass>> result = new HashSet<Class<? extends IModuleClass>>();
        Class<? extends IModuleClass> typeClass = this.getModuleInterfaceClass(type);
        if (typeClass != null && (baseClass = this.getModuleInterfaceClass(IModuleClass.CLASS_TYPE.MODULE)) != null) {
            Class<?>[] classes;
            for (Class<?> clazz : classes = Tools.getClasses(baseClass.getPackage().getName(), true)) {
                if (!typeClass.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
                result.add(clazz);
            }
        }
        return result;
    }

    public Set<Class<? extends IModuleClass>> getModelObjects() {
        return new HashSet<Class<? extends IModuleClass>>(this.supportedModelObjects);
    }

    public Set<Class<? extends IModuleClass>> getCommandObjects() {
        return new HashSet<Class<? extends IModuleClass>>(this.supportedCommandObjects);
    }

    public Set<Class<? extends IModuleClass>> getOfferObjects() {
        return new HashSet<Class<? extends IModuleClass>>(this.supportedOfferObjects);
    }

    @Override
    public Set<Class<? extends IModuleClass>> getSupportedObjects() {
        HashSet<Class<? extends IModuleClass>> result = new HashSet<Class<? extends IModuleClass>>();
        result.addAll(this.supportedModelObjects);
        result.addAll(this.supportedCommandObjects);
        result.addAll(this.supportedOfferObjects);
        return result;
    }

    protected abstract void _init();

    protected abstract Class<? extends IModuleClass> getModuleInterfaceClass(IModuleClass.CLASS_TYPE var1);

    @Override
    public URI getURI(String applicationID, String host) {
        return ExtensionIdentifier.generateURI(this.getExtensionId(), applicationID, host);
    }

    @Override
    public String getMetaInformationFromObject(AMetaInformation object, Enum<?> key) {
        if (object != null && key != null) {
            return object.getMetaInformation(this.getExtensionId(), key.name());
        }
        return null;
    }

    @Override
    public Set<Class<?>> getMetaInformationEnums() {
        return new HashSet(this.metaInformationEnums);
    }

    protected void addMetaInformationEnumClass(Class<? extends Enum<?>> metaEnumClass) {
        this.metaInformationEnums.add(metaEnumClass);
    }

    @Override
    public String getMetaInformationFromMap(Map<String, String> metaInformations, Enum<?> key) {
        if (metaInformations == null || key == null) {
            return null;
        }
        return metaInformations.get(AMetaInformation.buildExtensionKey(this.getExtensionId(), key.name()));
    }
}

