/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.crypt;

import bsc.api.Enumerations;
import bsc.sdk.api.crypt.ICipher;
import bsc.sdk.api.crypt.aes.AESCipher;

public abstract class CipherFactory {
    private static CipherFactory defaultFactory = null;

    public static CipherFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = CipherFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(CipherFactory factory) {
        defaultFactory = factory;
    }

    public static CipherFactory createDefaultFactory() {
        return new CipherFactory(){

            @Override
            public ICipher createInstance(Enumerations.EncryptionType encryption) {
                if (encryption != null) {
                    switch (encryption) {
                        case AES: {
                            return new AESCipher();
                        }
                        case NONE: {
                            return null;
                        }
                    }
                    throw new IllegalArgumentException("No cipher for type " + (Object)((Object)encryption));
                }
                return null;
            }
        };
    }

    public static ICipher createNewInstance(Enumerations.EncryptionType encryption) {
        return CipherFactory.getDefaultFactory().createInstance(encryption);
    }

    public abstract ICipher createInstance(Enumerations.EncryptionType var1);
}

