/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.compression;

import bsc.api.Enumerations;
import bsc.sdk.api.compression.ICompression;
import bsc.sdk.api.compression.zip.ZIPCompression;

public abstract class CompressionFactory {
    private static CompressionFactory defaultFactory = null;

    public static CompressionFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = CompressionFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(CompressionFactory factory) {
        defaultFactory = factory;
    }

    public static CompressionFactory createDefaultFactory() {
        return new CompressionFactory(){

            @Override
            public ICompression createInstance(Enumerations.CompressionType compression) {
                if (compression != null) {
                    switch (compression) {
                        case DEFLATE: {
                            return new ZIPCompression();
                        }
                        case NONE: {
                            return null;
                        }
                    }
                    throw new IllegalArgumentException("No compression for type " + (Object)((Object)compression));
                }
                return null;
            }
        };
    }

    public static ICompression createNewInstance(Enumerations.CompressionType compression) {
        return CompressionFactory.getDefaultFactory().createInstance(compression);
    }

    public abstract ICompression createInstance(Enumerations.CompressionType var1);
}

