/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.idpool;

import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.executors.DynamicScheduledCachedThreadPoolExecutor;
import bsc.sdk.api.application.idpool.IdPool;
import bsc.sdk.api.application.idpool.IdPoolSettings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class IdPoolManager {
    private HashMap<String, IdPool> pools = new HashMap();
    private DynamicScheduledCachedThreadPoolExecutor.ScheduledTask scheduledTask = null;
    private Executor command;
    private Environment environment;

    public void init(Environment environment) {
        this.environment = environment;
        this.command = new Executor();
        this.startCleanupTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdPool createNewPool(IdPoolSettings settings) {
        IdPool result = this.pools.get(settings.getId());
        if (result == null) {
            HashMap<String, IdPool> hashMap = this.pools;
            synchronized (hashMap) {
                result = new IdPool(settings);
                this.pools.put(settings.getId(), result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdPool createNewPool(String poolId, IdPool.GENERATOR_TYPE type) {
        IdPool result = this.pools.get(poolId);
        if (result == null) {
            HashMap<String, IdPool> hashMap = this.pools;
            synchronized (hashMap) {
                result = new IdPool(type, poolId);
                this.pools.put(poolId, result);
            }
        }
        return result;
    }

    public String getIdFromPool(String poolId) {
        HashMap<String, IdPool> hashMap = this.pools;
        synchronized (hashMap) {
            IdPool pool = this.pools.get(poolId);
            if (pool != null) {
                return pool.getId();
            }
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanPools() {
        HashMap<String, IdPool> hashMap = this.pools;
        synchronized (hashMap) {
            for (IdPool pool : this.pools.values()) {
                pool.cleanPool();
            }
        }
    }

    public void cleanPool(String poolId) {
        IdPool pool = this.pools.get(poolId);
        if (pool != null) {
            pool.cleanPool();
        }
    }

    public void importAssignedIdsIntoPool(String poolId, Collection<String> ids) {
        IdPool pool = this.pools.get(poolId);
        if (pool != null) {
            pool.importAssignedIds(ids);
        }
    }

    public void importAssignedIdsIntoPool(String poolId, Map<String, Long> ids) {
        IdPool pool = this.pools.get(poolId);
        if (pool != null) {
            pool.importAssignedIds(ids);
        }
    }

    public boolean startCleanupTimer() {
        if (this.scheduledTask != null) {
            return false;
        }
        this.getEnvironment().getApplication().getExecutorServiceBackgroundTasks().scheduleAtFixedDelay(this.command, 5L, 5L, TimeUnit.MINUTES);
        return true;
    }

    public boolean stopCleanupTimer() {
        if (this.scheduledTask == null) {
            return false;
        }
        this.scheduledTask.cancel();
        this.scheduledTask = null;
        return true;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePool(String poolId) {
        HashMap<String, IdPool> hashMap = this.pools;
        synchronized (hashMap) {
            this.pools.remove(poolId);
        }
    }

    private class Executor
    implements Runnable {
        private Executor() {
        }

        @Override
        public void run() {
            IdPoolManager.this.cleanPools();
        }
    }
}

