/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.executors;

import bsc.sdk.api.application.executors.DynamicNamedThread;
import bsc.sdk.api.application.executors.INamedRunnable;
import bsc.sdk.api.application.executors.NamedPriorityThreadFactory;
import bsc.sdk.api.application.executors.ReQueueRecjectedExecutionHandler;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicScheduledCachedThreadPoolExecutor
extends ThreadPoolExecutor {
    private static Logger logger = LoggerFactory.getLogger(DynamicScheduledCachedThreadPoolExecutor.class);
    private PriorityBlockingQueue<ScheduledTask> scheduledTasks;
    private LinkedBlockingQueue<Runnable> secondLevelQueue;
    private AtomicLong secondLevelCacheAddedTasksCounter;
    private int secondLevelCacheLargestSize = 0;
    private final Map<Runnable, Thread> currentLink;
    private Scheduler scheduler = null;
    private final String poolName;
    private final Thread dummyThread = new Thread();

    public DynamicScheduledCachedThreadPoolExecutor(String poolName, int corePoolSize, int maximumPoolSize) {
        this(poolName, corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, 5);
    }

    public DynamicScheduledCachedThreadPoolExecutor(String poolName, int corePoolSize, int maximumPoolSize, long threadTimeout, TimeUnit timeUnit, int threadPriority) {
        this(poolName, corePoolSize, maximumPoolSize, threadTimeout, timeUnit, threadPriority, new SynchronousQueue<Runnable>(), new ReQueueRecjectedExecutionHandler());
    }

    public DynamicScheduledCachedThreadPoolExecutor(String poolName, int corePoolSize, int maximumPoolSize, long threadTimeout, TimeUnit timeUnit, int threadPriority, BlockingQueue<Runnable> queue, RejectedExecutionHandler rejectedExecutionHandler) {
        super(corePoolSize, maximumPoolSize, threadTimeout, timeUnit, queue, DynamicScheduledCachedThreadPoolExecutor.createThreadFactory(poolName, threadPriority), rejectedExecutionHandler);
        this.currentLink = new ConcurrentHashMap<Runnable, Thread>();
        this.scheduledTasks = new PriorityBlockingQueue();
        this.secondLevelQueue = new LinkedBlockingQueue();
        this.secondLevelCacheAddedTasksCounter = new AtomicLong();
        this.poolName = poolName;
    }

    private static NamedPriorityThreadFactory createThreadFactory(String baseName, int threadPriority) {
        return new NamedPriorityThreadFactory(Objects.requireNonNull(baseName, "baseName must not be null!"), threadPriority);
    }

    public ScheduledTask scheduleAtFixedRate(Runnable runnable, long delay, long rate, TimeUnit timeUnit) {
        return this.scheduleAtFixedRateAndCount(runnable, delay, rate, timeUnit, -1L);
    }

    public ScheduledTask scheduleAtFixedRateAndCount(Runnable runnable, long delay, long rate, TimeUnit timeUnit, long executeCount) {
        ScheduledTask task = new ScheduledTask(runnable, timeUnit.toMillis(delay), timeUnit.toMillis(rate), true, executeCount);
        this.addTask(task);
        return task;
    }

    public ScheduledTask scheduleAtFixedDelay(Runnable runnable, long delay, long interval, TimeUnit timeUnit) {
        return this.scheduleAtFixedDelayAndCount(runnable, delay, interval, timeUnit, -1L);
    }

    public ScheduledTask scheduleAtFixedDelayAndCount(Runnable runnable, long delay, long interval, TimeUnit timeUnit, long executeCount) {
        ScheduledTask task = new ScheduledTask(runnable, timeUnit.toMillis(delay), timeUnit.toMillis(interval), false, executeCount);
        this.addTask(task);
        return task;
    }

    public ScheduledTask scheduleOnce(Runnable runnable, long delay, TimeUnit timeUnit) {
        return this.scheduleAtFixedDelayAndCount(runnable, delay, 0L, timeUnit, 0L);
    }

    protected void addToSecondLevelQueue(Runnable runnable) {
        this.currentLink.remove(runnable);
        try {
            int secondLevelCacheSize;
            if (!this.secondLevelQueue.offer(runnable)) {
                this.secondLevelQueue.add(runnable);
            }
            if (this.secondLevelCacheAddedTasksCounter.incrementAndGet() == Long.MAX_VALUE) {
                this.secondLevelCacheAddedTasksCounter.set(0L);
            }
            if ((secondLevelCacheSize = this.secondLevelQueue.size()) > this.secondLevelCacheLargestSize) {
                this.secondLevelCacheLargestSize = secondLevelCacheSize;
            }
            this.interruptScheduler();
        }
        catch (ClassCastException | IllegalArgumentException | IllegalStateException | NullPointerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public long getSecondLevelCacheAddedTasksCount() {
        return this.secondLevelCacheAddedTasksCounter.get();
    }

    public long getSecondLevelCacheCount() {
        return this.secondLevelQueue.size();
    }

    public int getSecondLevelCacheLargestSize() {
        return this.secondLevelCacheLargestSize;
    }

    private void addTask(ScheduledTask task) {
        long nextExecution = this.scheduledTasks.isEmpty() ? 0L : this.scheduledTasks.peek().getNextExecution();
        this.scheduledTasks.add(task);
        if (task.nextExecution < nextExecution || this.scheduler != null && this.scheduler.isIdle()) {
            this.interruptScheduler();
        }
    }

    private void removeTask(ScheduledTask task) {
        boolean firstElement = this.scheduledTasks.isEmpty() ? false : this.scheduledTasks.peek().equals(task);
        this.scheduledTasks.remove(task);
        if (firstElement) {
            this.interruptScheduler();
        }
    }

    private void reScheduleTask(ScheduledTask task) {
        task.updateNextExecutionTime();
        this.addTask(task);
    }

    private void stopScheduler() {
        if (this.scheduler != null) {
            this.scheduler.setRunning(false);
            this.scheduler._interrupt();
            this.scheduler = null;
        }
    }

    private synchronized boolean startScheduler() {
        boolean createScheduler;
        boolean bl = createScheduler = this.scheduler == null;
        if (createScheduler) {
            this.scheduler = new Scheduler();
        }
        return createScheduler;
    }

    @Override
    public void shutdown() {
        this.stopScheduler();
        this.scheduledTasks.clear();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.stopScheduler();
        this.scheduledTasks.clear();
        return super.shutdownNow();
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.currentLink.put(r, t);
        if (r instanceof INamedRunnable && t instanceof DynamicNamedThread) {
            INamedRunnable runnable = (INamedRunnable)r;
            DynamicNamedThread thread = (DynamicNamedThread)t;
            thread.setDynamicName(runnable);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        Thread thread;
        super.afterExecute(r, t);
        if (!this.secondLevelQueue.isEmpty()) {
            this.interruptScheduler();
        }
        if ((thread = this.currentLink.remove(r)) instanceof DynamicNamedThread) {
            DynamicNamedThread dnt = (DynamicNamedThread)thread;
            dnt.resetDynamicName();
        }
    }

    private void interruptScheduler() {
        if (!this.startScheduler() && this.scheduler.sleeping) {
            this.scheduler._interrupt();
        }
    }

    public String getPoolName() {
        return this.poolName;
    }

    public boolean schedulerIsRunning() {
        return this.scheduler == null ? false : this.scheduler.isRunning();
    }

    public boolean isAnyThreadReadyToUse() {
        return this.currentLink.size() < this.getMaximumPoolSize();
    }

    public int getAvailableThreadCount() {
        return this.getMaximumPoolSize() - this.currentLink.size();
    }

    public int getTest() {
        return this.currentLink.size();
    }

    @Override
    public void execute(Runnable command) {
        if (this.isAnyThreadReadyToUse()) {
            this.currentLink.put(command, this.dummyThread);
            super.execute(command);
        } else {
            this.addToSecondLevelQueue(command);
        }
    }

    public class ScheduledTask
    implements Comparable<ScheduledTask>,
    INamedRunnable {
        private long nextExecution;
        private long delay;
        private long interval;
        private boolean intervalIsRate;
        private long executeCount;
        private final Runnable runnable;
        private boolean canceled = false;
        private final String name;

        public ScheduledTask(Runnable runnable, long delay, long interval, boolean intervalIsRate, long executeCount) {
            this.runnable = runnable;
            this.name = this.runnable instanceof INamedRunnable ? ((INamedRunnable)this.runnable).getName() : this.getClass().getSimpleName();
            this.delay = delay;
            this.interval = interval;
            this.intervalIsRate = intervalIsRate;
            this.executeCount = executeCount;
            this.nextExecution = delay > 0L ? System.currentTimeMillis() + delay : System.currentTimeMillis();
        }

        @Override
        public int compareTo(ScheduledTask o) {
            return Long.compare(this.nextExecution, o.getNextExecution());
        }

        public long getNextExecution() {
            return this.nextExecution;
        }

        public long getDelay() {
            return this.delay;
        }

        public void setDelay(long delay) {
            this.delay = delay;
        }

        public long getInterval() {
            return this.interval;
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        private void updateNextExecutionTime() {
            this.nextExecution = System.currentTimeMillis() + this.interval;
        }

        public void cancel() {
            if (!this.canceled) {
                this.canceled = true;
                DynamicScheduledCachedThreadPoolExecutor.this.removeTask(this);
            }
        }

        @Override
        public void run() {
            if (!this.canceled) {
                this.runnable.run();
                if (this.executeCount > 0L) {
                    --this.executeCount;
                }
                if (!this.intervalIsRate && this.interval > 0L && this.executeCount != 0L) {
                    DynamicScheduledCachedThreadPoolExecutor.this.reScheduleTask(this);
                }
            }
        }

        public long getExecuteCount() {
            return this.executeCount;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private class Scheduler
    extends Thread {
        private boolean running = true;
        private long idleTime = TimeUnit.MINUTES.toMillis(1L);
        private boolean sleeping = false;

        public Scheduler() {
            this.setName(DynamicScheduledCachedThreadPoolExecutor.this.poolName + "->" + this.getClass().getSimpleName());
            this.setPriority(10);
            this.start();
        }

        @Override
        public void run() {
            long idleTimestamp = 0L;
            long nextExecution = 0L;
            Runnable runnable = null;
            while (this.running) {
                nextExecution = 0L;
                while (this.running && !DynamicScheduledCachedThreadPoolExecutor.this.secondLevelQueue.isEmpty() && DynamicScheduledCachedThreadPoolExecutor.this.isAnyThreadReadyToUse()) {
                    runnable = (Runnable)DynamicScheduledCachedThreadPoolExecutor.this.secondLevelQueue.poll();
                    if (runnable == null) continue;
                    DynamicScheduledCachedThreadPoolExecutor.this.execute(runnable);
                }
                if (!DynamicScheduledCachedThreadPoolExecutor.this.secondLevelQueue.isEmpty() && DynamicScheduledCachedThreadPoolExecutor.this.isAnyThreadReadyToUse()) {
                    nextExecution = System.currentTimeMillis();
                } else if (!DynamicScheduledCachedThreadPoolExecutor.this.scheduledTasks.isEmpty()) {
                    ScheduledTask tmpTask;
                    while (this.running && !DynamicScheduledCachedThreadPoolExecutor.this.scheduledTasks.isEmpty() && ((ScheduledTask)DynamicScheduledCachedThreadPoolExecutor.this.scheduledTasks.peek()).getNextExecution() <= System.currentTimeMillis()) {
                        ScheduledTask task = (ScheduledTask)DynamicScheduledCachedThreadPoolExecutor.this.scheduledTasks.poll();
                        boolean reSchedule = task.intervalIsRate ? task.getInterval() > 0L && task.getExecuteCount() != 0L && task.getExecuteCount() != 1L : false;
                        DynamicScheduledCachedThreadPoolExecutor.this.execute(task);
                        if (!reSchedule) continue;
                        DynamicScheduledCachedThreadPoolExecutor.this.reScheduleTask(task);
                    }
                    if (!DynamicScheduledCachedThreadPoolExecutor.this.scheduledTasks.isEmpty() && (tmpTask = (ScheduledTask)DynamicScheduledCachedThreadPoolExecutor.this.scheduledTasks.peek()) != null) {
                        long nextScheduledExecution = tmpTask.getNextExecution();
                        if (nextExecution == 0L || nextExecution > nextScheduledExecution) {
                            nextExecution = nextScheduledExecution;
                        }
                    }
                }
                if (nextExecution <= 0L) {
                    long now = System.currentTimeMillis();
                    long idleTimeUntilNow = now - idleTimestamp;
                    if (idleTimestamp == 0L) {
                        idleTimestamp = now;
                        this._sleep(this.idleTime);
                        continue;
                    }
                    if (idleTimeUntilNow < this.idleTime) {
                        this._sleep(this.idleTime - idleTimeUntilNow);
                        continue;
                    }
                    if (idleTimeUntilNow <= this.idleTime) continue;
                    DynamicScheduledCachedThreadPoolExecutor.this.stopScheduler();
                    continue;
                }
                idleTimestamp = 0L;
                long sleepTime = nextExecution - System.currentTimeMillis();
                if (sleepTime <= 0L) continue;
                this._sleep(sleepTime);
            }
        }

        protected void _interrupt() {
            this.sleeping = false;
        }

        private void _sleep(long msToSleep) {
            this.sleeping = true;
            long start = System.currentTimeMillis();
            while (this.sleeping && System.currentTimeMillis() - start < msToSleep) {
                try {
                    Scheduler.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.sleeping = false;
        }

        public boolean isRunning() {
            return this.running;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }

        public boolean isIdle() {
            return this.idleTime != 0L;
        }
    }
}

