/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.executors;

import bsc.sdk.api.application.executors.INamedRunnable;
import java.util.Objects;

public class DynamicNamedThread
extends Thread {
    private static final String seperator = " | ";
    private final String baseName;

    public DynamicNamedThread(Runnable runnable, String baseName) {
        super(runnable, Objects.requireNonNull(baseName));
        this.baseName = baseName;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setDynamicName(String name) {
        this.setName(this.baseName + seperator + name);
    }

    public void setDynamicName(INamedRunnable namedRunnable) {
        this.setDynamicName(namedRunnable.getName());
    }

    public void resetDynamicName() {
        this.setName(this.baseName);
    }
}

