/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.environment;

import bsc.sdk.api.application.environment.Environment;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class EnvironmentRegistry {
    private static final Map<String, Environment> registry = new ConcurrentHashMap<String, Environment>();

    public static void registerEnvironment(Environment environment) {
        if (environment != null) {
            registry.put(environment.getApplicationId(), environment);
        }
    }

    public static void unregisterEnvironment(Environment environment) {
        if (environment != null) {
            EnvironmentRegistry.unregisterEnvironment(environment.getApplicationId());
        }
    }

    public static void unregisterEnvironment(String applicationID) {
        if (applicationID != null) {
            registry.remove(applicationID);
        }
    }

    public static Environment getEnvironment(String applicationID) {
        Environment result = null;
        if (applicationID != null) {
            result = registry.get(applicationID);
        }
        return result;
    }

    public static Collection<Environment> getAllRegistryEntries() {
        return Collections.unmodifiableCollection(registry.values());
    }
}

