/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.client.transceiver.state;

import bsc.api.transport.TransmissionObject;
import bsc.api.transport.commands.ConnectionRequest;
import bsc.api.transport.model.Caps;
import bsc.api.transport.model.Settings;
import bsc.api.transport.result.ObjectResult;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.notification.objects.AddMetaData;
import bsc.sdk.api.transceiver.ChannelWorker;
import bsc.sdk.api.transceiver.ITransceiver;
import bsc.sdk.api.transceiver.state.AStateInit;
import bsc.sdk.api.transceiver.state.ITransceiverState;
import bsc.sdk.api.transceiver.state.StateConfiguration;
import bsc.sdk.api.transceiver.state.StateFactory;
import bsc.sdk.api.user.session.ISession;
import bsc.sdk.api.user.session.manager.SessionIdentifier;

public class StateInit
extends AStateInit {
    private ISession session;
    private Stage currentStage = Stage.DONE;

    public StateInit(StateConfiguration stateSettings) {
        super(stateSettings);
        this.session = stateSettings.getSession();
        this.currentStage = Stage.CONTACTING_SERVER;
    }

    @Override
    public int getLevel() {
        return 0;
    }

    @Override
    public ITransceiverState execute() {
        try {
            switch (this.currentStage) {
                default: {
                    return this;
                }
                case CONTACTING_SERVER: {
                    ConnectionRequest connectionRequest = new ConnectionRequest();
                    this.fireNotification(new AddMetaData(connectionRequest));
                    if (this.session != null && this.session.getSessionID() != null) {
                        connectionRequest.setSessionID(this.session.getSessionID());
                    }
                    this.controller.write(new TransmissionObject(this.getNewTransmissionId(), connectionRequest), false, ChannelWorker.WriteMode.JSON_PROTOCOL);
                    this.currentStage = Stage.CHECKING_FOR_SESSION;
                    this.identifier.getObjectInstance().getChannelHandler().start();
                    return this;
                }
                case CHECKING_FOR_SESSION: 
            }
            TransmissionObject transmissionObject = this.controller.nextIncomingTransmission();
            Caps serverCaps = null;
            if (transmissionObject.getObject() instanceof Caps || transmissionObject.getObject() instanceof ObjectResult) {
                serverCaps = (Caps)this.checkResult(transmissionObject, Caps.class);
            }
            if (this.session != null && this.session.getSessionID() != null) {
                Settings settings = new Settings(this.session.getProtocolType(), this.session.getCompressionType(), this.session.getEncryptionType(), this.session.getApiVersion(), this.session.getApiExtensions());
                this.environment.getExtensionManager().subscribeForInternalExtensions(this.identifier);
                this.environment.getExtensionManager().subscribe(settings.getApiExtensions(), this.identifier);
                SessionIdentifier sessionIdentifier = (SessionIdentifier)this.environment.getSessionManager().getIdentifierInstance(this.session);
                this.controller.initialize(sessionIdentifier);
                this.session.setLastUsedTimestamp(System.currentTimeMillis());
                sessionIdentifier.updateObject(this.session);
                this.environment.getExtensionManager().subscribe(settings.getApiExtensions(), this.identifier);
                this.controller.fireStateChanged(ITransceiver.TransceiverState.READY);
                return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.WORK, this.identifier, this.environment));
            }
            Caps caps = this.getCaps();
            this.fireNotification(new AddMetaData(caps));
            this.controller.write(new TransmissionObject(this.getNewTransmissionId(), caps), ChannelWorker.WriteMode.JSON_PROTOCOL);
            StateConfiguration stateSettings = new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.AUTH, this.identifier, this.environment);
            stateSettings.setSession(this.session);
            stateSettings.setMetaInformations(serverCaps.getAllMetaInformations());
            return StateFactory.getDefaultFactory().createState(stateSettings);
        }
        catch (TransceiverException e) {
            return this.error(e);
        }
    }

    @Override
    public ITransceiverState disconnect(boolean terminate) {
        return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.DISCONNECT, this.identifier, this.environment));
    }

    @Override
    public ITransceiverState error(TransceiverException exception) {
        StateConfiguration stateSettings = new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.ERROR, this.identifier, this.environment);
        stateSettings.setThrowable(exception);
        return StateFactory.getDefaultFactory().createState(stateSettings);
    }

    private static enum Stage {
        CONTACTING_SERVER,
        CHECKING_FOR_SESSION,
        DONE;

    }
}

