/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.client.transceiver.state;

import bsc.api.Enumerations;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.notification.state.ConnectionStatus;
import bsc.sdk.api.transceiver.state.AStateExit;
import bsc.sdk.api.transceiver.state.ITransceiverState;
import bsc.sdk.api.transceiver.state.StateConfiguration;
import bsc.sdk.api.transceiver.state.StateFactory;

public class StateError
extends AStateExit {
    private Throwable throwable;
    private String message;

    public StateError(StateConfiguration stateSettings) {
        super(stateSettings);
        this.throwable = stateSettings.getThrowable();
        this.message = stateSettings.getThrowable().getMessage();
        if (this.throwable instanceof TransceiverException) {
            TransceiverException t = (TransceiverException)this.throwable;
            this.message = t.getErrorType().toString();
        }
        this.controller.fireNotification(new ConnectionStatus(ConnectionStatus.Status.Rejected, this.message));
    }

    @Override
    public int getLevel() {
        return 3;
    }

    @Override
    public ITransceiverState execute() {
        TransceiverException transceiverException = this.throwable instanceof TransceiverException ? (TransceiverException)this.throwable : (this.throwable != null && this.message != null ? new TransceiverException(Enumerations.ErrorType.EXCEPTION, this.message, this.throwable) : (this.message != null ? new TransceiverException(Enumerations.ErrorType.EXCEPTION, this.message) : (this.throwable != null ? new TransceiverException(Enumerations.ErrorType.EXCEPTION, this.throwable) : new TransceiverException(Enumerations.ErrorType.EXCEPTION))));
        this.controller.error(transceiverException);
        return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.DISCONNECT, this.identifier, this.environment));
    }

    @Override
    public ITransceiverState error(TransceiverException exception) {
        return null;
    }

    @Override
    public ITransceiverState disconnect(boolean terminate) {
        return null;
    }
}

