/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.client;

import bsc.sdk.api.application.client.AClientBuilder;
import bsc.sdk.api.transceiver.ChannelHandlerCompletionSync;
import bsc.sdk.api.transceiver.ChannelWorker;
import bsc.sdk.net.ISocket;
import bsc.sdk.net.SocketFactory;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBuilderSync
extends AClientBuilder<ClientBuilderSync> {
    private static Logger logger = LoggerFactory.getLogger(ClientBuilderSync.class);
    private ClientType clientType = ClientType.SOCKET_SYNC;

    @Override
    ChannelWorker createChannelWorker(String serverAddress, int port, ExecutorService executorService) {
        ChannelHandlerCompletionSync worker = null;
        try {
            Socket socket = new Socket(serverAddress, port);
            ISocket iSocket = null;
            iSocket = this.clientType == ClientType.SOCKET_SYNC ? SocketFactory.createNewMobileInstance(socket, socket.getInputStream(), socket.getOutputStream()) : SocketFactory.createNewWebsocketInstance(socket, socket.getInputStream(), socket.getOutputStream());
            worker = new ChannelHandlerCompletionSync(iSocket, executorService);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return worker;
    }

    public ClientBuilderSync setClientType(ClientType clientType) {
        this.clientType = clientType;
        return this;
    }

    public static enum ClientType {
        SOCKET_SYNC,
        WEBSOCKET_SYNC;

    }
}

