/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application;

import bsc.sdk.api.application.IApplication;
import bsc.sdk.api.application.IObjectListener;
import bsc.sdk.api.application.builder.Product;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.environment.EnvironmentBuilder;
import bsc.sdk.api.application.environment.EnvironmentRegistry;
import bsc.sdk.api.application.executors.DynamicScheduledCachedThreadPoolExecutor;
import bsc.sdk.api.application.manager.ApplicationManagerFactory;
import bsc.sdk.api.application.manager.IApplicationManager;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AApplication
extends Thread
implements IApplication {
    protected final Logger logger;
    @Deprecated
    private static int scheduledExecutorServiceCorePoolSize = 5;
    private boolean shutdownInProgress;
    protected Environment environment;
    private String applicationId = this.getClass().getSimpleName();
    private String applicationName = this.getClass().getSimpleName();
    private String applicationHost = "local";
    private IApplicationManager applicationManager;
    protected DynamicScheduledCachedThreadPoolExecutor executorServiceIoPriority;
    protected DynamicScheduledCachedThreadPoolExecutor executorServiceBackgroundTasks;
    protected final Map<String, Set<IObjectListener>> objectListeners = new ConcurrentHashMap<String, Set<IObjectListener>>();
    private Queue<IApplicationManager> applicationManagers;

    public AApplication() {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.applicationManagers = new ConcurrentLinkedQueue<IApplicationManager>();
        this.setName(this.applicationName);
    }

    @Override
    public void shutdownExecutorService(boolean now) {
        if (now) {
            this.executorServiceIoPriority.shutdownNow();
            this.executorServiceBackgroundTasks.shutdownNow();
        } else {
            this.executorServiceIoPriority.shutdown();
            this.executorServiceBackgroundTasks.shutdown();
        }
        try {
            boolean wasTerminated = this.executorServiceIoPriority.awaitTermination(2L, TimeUnit.SECONDS);
            this.logger.trace("executorServiceIoPriority was terminated: {}", (Object)wasTerminated);
            wasTerminated = this.executorServiceBackgroundTasks.awaitTermination(2L, TimeUnit.SECONDS);
            this.logger.trace("executorServiceBackgroundTasks was terminated: {}", (Object)wasTerminated);
        }
        catch (InterruptedException e1) {
            this.logger.error("InterruptedException while waiting for executor service termination.", (Throwable)e1);
        }
    }

    @Override
    public Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = Product.create(EnvironmentBuilder.class).setApplicationManager(this.getApplicationManager()).setApplicationId(this.getApplicationId()).setApplicationName(this.getApplicationName()).setHostID(this.getApplicationHost()).buildProduct();
        }
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        this.setName(this.getFullName());
    }

    public IApplicationManager getApplicationManager() {
        if (this.applicationManager == null) {
            this.applicationManager = ApplicationManagerFactory.createNewInstance();
            this.setApplicationId(this.applicationManager.generateApplicationId());
        }
        return this.applicationManager;
    }

    public void setApplicationManager(IApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
        this.setName(this.getFullName());
    }

    @Override
    public void shutdown() {
        this._shutdown();
        this.environment.getTransmissionManager().shutdown();
        this.environment.getHandleManager().shutdown();
        this.environment.getIdPoolManager().stopCleanupTimer();
        this.environment.getObjectManager().shutdown();
        this.environment.getSessionManager().shutdown();
        this.environment.getTransceiverManager().shutdown();
        this.environment.getUserCredentialManager().shutdown();
        this.environment.getUserGroupManager().shutdown();
        this.environment.getExtensionManager().shutdown();
        this.shutdownExecutorService(false);
        this.environment.getApplicationManager().removeObject(this);
        EnvironmentRegistry.unregisterEnvironment(this.getApplicationId());
    }

    @Override
    public String getFullName() {
        return "BSC-SDK " + this.applicationName + "#" + this.applicationId;
    }

    public boolean isShutdownInProgress() {
        return this.shutdownInProgress;
    }

    public void setShutdownInProgress(boolean shutdownInProgress) {
        this.shutdownInProgress = shutdownInProgress;
    }

    public String getApplicationHost() {
        return this.applicationHost;
    }

    public void setApplicationHost(String applicationHost) {
        this.applicationHost = applicationHost;
    }

    protected abstract void _shutdown();

    public static int getScheduledExecutorServiceCorePoolSize() {
        return scheduledExecutorServiceCorePoolSize;
    }

    public static void setScheduledExecutorServiceCorePoolSize(int scheduledExecutorServiceCorePoolSize) {
        AApplication.scheduledExecutorServiceCorePoolSize = scheduledExecutorServiceCorePoolSize;
    }

    @Override
    public void publishObject(Enum<?> tag, Object object) {
        this.publishObject(Objects.requireNonNull(tag, "tag must not be null!").name(), object);
    }

    @Override
    public void publishObject(String tag, Object object) {
        Set<IObjectListener> listeners = this.objectListeners.get(Objects.requireNonNull(tag, "tag must not be null!"));
        if (listeners != null) {
            for (IObjectListener iObjectListener : listeners) {
                iObjectListener.objectReceived(tag, Objects.requireNonNull(object, "object must not be null!"));
            }
        }
    }

    @Override
    public void registerObjectListener(IObjectListener listener) {
        if (listener != null) {
            for (String tag : Objects.requireNonNull(listener.getTags(), "tags must not be null!")) {
                Set<IObjectListener> listeners = this.objectListeners.get(tag);
                if (listeners == null) {
                    listeners = Collections.newSetFromMap(new ConcurrentHashMap());
                    this.objectListeners.put(tag, listeners);
                }
                listeners.add(listener);
            }
        }
    }

    @Override
    public void removeObjectListener(IObjectListener listener) {
        if (listener != null) {
            for (String tag : Objects.requireNonNull(listener.getTags(), "tags must not be null!")) {
                Set<IObjectListener> listeners = this.objectListeners.get(tag);
                if (listeners == null) continue;
                listeners.remove(listener);
                if (!listeners.isEmpty()) continue;
                this.objectListeners.remove(tag);
            }
        }
    }

    @Override
    public void fireStateChanged(IApplicationManager.ApplicationState state) {
        for (IApplicationManager applicationManager : this.applicationManagers) {
            applicationManager.applicationStateChanged(this, state);
        }
    }

    @Override
    public void addApplicationManager(IApplicationManager applicationManager) {
        if (applicationManager != null && !this.applicationManagers.contains(applicationManager)) {
            this.applicationManagers.add(applicationManager);
        }
    }

    @Override
    public boolean removeApplicationManager(IApplicationManager applicationManager) {
        return this.applicationManagers.remove(applicationManager);
    }

    public DynamicScheduledCachedThreadPoolExecutor createExecutorServiceIoPriority() {
        return new DynamicScheduledCachedThreadPoolExecutor(this.getFullName() + " IO-Priority", Runtime.getRuntime().availableProcessors(), 1024, 1L, TimeUnit.MINUTES, 8);
    }

    public DynamicScheduledCachedThreadPoolExecutor createExecutorServiceBackgroundTasks() {
        return new DynamicScheduledCachedThreadPoolExecutor(this.getFullName() + " System", 2, 1024, 1L, TimeUnit.MINUTES, 6);
    }

    @Override
    public DynamicScheduledCachedThreadPoolExecutor getExecutorServiceIoPriority() {
        if (this.executorServiceIoPriority == null) {
            this.executorServiceIoPriority = this.createExecutorServiceIoPriority();
        }
        return this.executorServiceIoPriority;
    }

    @Override
    public DynamicScheduledCachedThreadPoolExecutor getExecutorServiceBackgroundTasks() {
        if (this.executorServiceBackgroundTasks == null) {
            this.executorServiceBackgroundTasks = this.createExecutorServiceBackgroundTasks();
        }
        return this.executorServiceBackgroundTasks;
    }
}

