/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api;

import bsc.api.IIdentifiable;
import bsc.sdk.api.IIdentifierCache;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.executors.DynamicScheduledCachedThreadPoolExecutor;
import bsc.sdk.api.application.executors.INamedRunnable;
import bsc.sdk.api.application.identifier.IIdentifier;
import bsc.sdk.api.application.idpool.IdPool;
import bsc.sdk.api.application.idpool.IdPoolSettings;
import bsc.sdk.tools.Tools;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AIdentifierCache<T extends IIdentifier<O>, O extends IIdentifiable>
implements IIdentifierCache<T, O> {
    protected boolean cacheCleanerActive = true;
    protected DynamicScheduledCachedThreadPoolExecutor.ScheduledTask cacheCleanerFuture = null;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Map<String, T> identifierCache = new ConcurrentHashMap<String, T>();
    protected IdPool idPool;
    protected Class<T> clazz = this.getIdentifierClass();
    protected Environment environment = null;

    @Override
    public void init(Environment environment) {
        if (this.environment == null) {
            this.environment = Objects.requireNonNull(environment, "environment must not be null!");
        }
        this.cacheCleanerFuture = environment.getApplication().getExecutorServiceBackgroundTasks().scheduleAtFixedDelay(new CacheCleaner(), Tools.getRandomNumberInRange(1, 60), 60L, TimeUnit.MINUTES);
    }

    protected IdPoolSettings getIdPoolSettings() {
        return new IdPoolSettings(this.getClass().getName(), IdPool.GENERATOR_TYPE.RANDOM, this.getClass().getSimpleName() + "#");
    }

    private boolean initIdPool() {
        if (this.idPool == null && this.environment != null) {
            this.idPool = this.environment.getIdPoolManager().createNewPool(this.getIdPoolSettings());
        }
        return this.idPool != null;
    }

    protected void freeID(String id) {
        if (this.idPool != null) {
            this.idPool.freeID(id);
        }
    }

    public String getUniqueID() {
        if (this.idPool == null) {
            if (this.initIdPool()) {
                return this.idPool.getId();
            }
        } else {
            return this.idPool.getId();
        }
        return null;
    }

    @Override
    public T getIdentifierInstance(String fullQualifiedIdentifiableString) {
        return this.getIdentifierInstance(fullQualifiedIdentifiableString, true);
    }

    @Override
    public T getIdentifierInstance(String fullQualifiedIdentifiableString, boolean verifyURI) {
        IIdentifier result = null;
        if (verifyURI) {
            try {
                result = this.getIdentifierInstance((O)new URI(Objects.requireNonNull(fullQualifiedIdentifiableString, "fullQualifiedIdentifiableString must not be null!")));
            }
            catch (NullPointerException | URISyntaxException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            result = (IIdentifier)this.identifierCache.get(fullQualifiedIdentifiableString);
        }
        return (T)result;
    }

    @Override
    public T getIdentifierInstance(URI uri) {
        if (uri == null) {
            return null;
        }
        String id = null;
        try {
            id = URLDecoder.decode(uri.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        IIdentifier result = (IIdentifier)this.identifierCache.get(id);
        if (result == null && (result = this.getIdentifierInstance(this.clazz, uri)) != null) {
            this.identifierCache.put(id, result);
        }
        return (T)result;
    }

    @Override
    public T getIdentifierInstance(O object) {
        if (this.environment == null || object == null) {
            return null;
        }
        URI uri = null;
        try {
            uri = object.getURI(this.environment.getApplicationId(), this.environment.getHostID());
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        if (uri == null) {
            return null;
        }
        return this.getIdentifierInstance((O)uri);
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    protected <N extends IIdentifier<O>> N getIdentifierInstance(Class<N> clazz, URI uri) {
        IIdentifier result = null;
        try {
            Constructor<N> constructor = clazz.getDeclaredConstructor(URI.class);
            constructor.setAccessible(true);
            result = (IIdentifier)constructor.newInstance(uri);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return (N)result;
    }

    public void removeIdentifier(URI uri) {
        if (uri != null) {
            try {
                String id = URLDecoder.decode(uri.toString(), "UTF-8");
                this.identifierCache.remove(id);
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void printCache() {
        this.logger.info("########################################################################");
        this.logger.info(this.clazz + " identifier cache");
        this.logger.info("########################################################################");
        for (Map.Entry<String, T> entry : this.identifierCache.entrySet()) {
            this.logger.info(entry.getKey() + " -> " + entry.getValue());
        }
        this.logger.info("------------------------------------------------------------------------");
    }

    protected abstract Class<T> getIdentifierClass();

    protected abstract Class<O> getObjectClass();

    @Override
    public void shutdown() {
        this.cacheCleanerFuture.cancel();
    }

    private class CacheCleaner
    implements INamedRunnable {
        private CacheCleaner() {
        }

        @Override
        public void run() {
            if (AIdentifierCache.this.cacheCleanerActive) {
                try {
                    int count = 0;
                    AIdentifierCache.this.logger.trace("Start cache cleanup. Cache size: " + AIdentifierCache.this.identifierCache.size());
                    for (IIdentifier identifier : AIdentifierCache.this.identifierCache.values()) {
                        if (!AIdentifierCache.this.cacheCleanerActive || identifier.objectExists()) continue;
                        ++count;
                        AIdentifierCache.this.removeIdentifier(identifier.getURI());
                    }
                    AIdentifierCache.this.logger.trace(count + " cache entries removed!");
                }
                catch (Exception e) {
                    AIdentifierCache.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public String getName() {
            return this.getClass().getSimpleName() + "->CacheCleaner";
        }
    }
}

