/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.modules.tf.model;

import bsc.api.ApiObjectIdentifier;
import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.AMetaInformation;
import bsc.api.basic.commands.offer.AOffer;
import bsc.api.modules.tf.model.IModelTF;
import bsc.api.modules.tf.model.TapSequence;
import bsc.api.modules.tf.model.TapSignal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TapFunction
extends AMetaInformation
implements IModelTF,
IIdentifiableApiObject {
    private static final long serialVersionUID = 7284891212470311825L;
    protected String id;
    protected String name;
    protected int timeFrame = 4;
    protected boolean explicitCheck = true;
    protected boolean executeImmediately;
    protected boolean timeFramePerSignal;
    protected int negativeCount;
    protected int negativeCountAlertValue = 3;
    protected List<TapSequence> sequences;
    protected List<AOffer<?>> commandOffers;
    protected List<String> monitoredDevices;

    public TapFunction() {
    }

    public TapFunction(String id, String name, int timeFrame, int negativeCountAlertValue, boolean explicitCheck, boolean executeImmediately, boolean timeFramePerSignal, List<String> monitoredDevices, List<TapSequence> sequences) {
        this.id = id;
        this.name = name;
        this.timeFrame = timeFrame;
        this.negativeCountAlertValue = negativeCountAlertValue;
        this.explicitCheck = explicitCheck;
        this.executeImmediately = executeImmediately;
        this.timeFramePerSignal = timeFramePerSignal;
        this.monitoredDevices = monitoredDevices;
        this.sequences = sequences;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getTimeFrame() {
        return this.timeFrame;
    }

    public void setTimeFrame(Integer timeFrame) {
        this.timeFrame = timeFrame;
    }

    public boolean isExplicitCheck() {
        return this.explicitCheck;
    }

    public void setExplicitCheck(boolean explicitCheck) {
        this.explicitCheck = explicitCheck;
    }

    public boolean isExecuteImmediately() {
        return this.executeImmediately;
    }

    public void setExecuteImmediately(boolean executeImmediately) {
        this.executeImmediately = executeImmediately;
    }

    public boolean isTimeFramePerSignal() {
        return this.timeFramePerSignal;
    }

    public void setTimeFramePerSignal(boolean timeFramePerSignal) {
        this.timeFramePerSignal = timeFramePerSignal;
    }

    public List<String> getMonitoredDevices() {
        return this.monitoredDevices;
    }

    public void setMonitoredDevices(List<String> monitoredDevices) {
        this.monitoredDevices = monitoredDevices;
    }

    public Integer getNegativeCount() {
        return this.negativeCount;
    }

    public List<TapSequence> getSequences() {
        return this.sequences;
    }

    public void setSequences(List<TapSequence> sequences) {
        this.sequences = sequences;
    }

    public List<TapSequence> getPossibleSequences(List<TapSignal> sequence) {
        ArrayList<TapSequence> result = new ArrayList<TapSequence>();
        if (this.sequences != null) {
            result.addAll(this.sequences);
            Iterator itr = result.iterator();
            while (itr.hasNext()) {
                if (((TapSequence)itr.next()).isPossibleSameSequence(sequence)) continue;
                itr.remove();
            }
        }
        return result;
    }

    public List<AOffer<?>> getCommandOffers() {
        return this.commandOffers;
    }

    public void setCommandOffers(List<AOffer<?>> commandOffers) {
        this.commandOffers = commandOffers;
    }

    public void clearCommandOffers() {
        if (this.commandOffers != null) {
            this.commandOffers.clear();
        }
    }

    public void addCommandOffer(AOffer<?> offer) {
        if (this.commandOffers == null) {
            this.commandOffers = new ArrayList();
        }
        this.commandOffers.add(offer);
    }

    @Override
    public URI getURI(String applicationID, String host) {
        return ApiObjectIdentifier.getTapFunctionUri(this.id, applicationID, host);
    }
}

