/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.modules.teachin.referenceid;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.teachin.referenceid.GenericDevice;
import bsc.api.modules.teachin.referenceid.IReferenceID;
import bsc.api.modules.teachin.referenceid.ReferenceIDs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum EEP implements IReferenceID
{
    A5_02_01("enocean.enocean.eep.a5-02-01", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_02("enocean.enocean.eep.a5-02-02", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_03("enocean.enocean.eep.a5-02-03", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_04("enocean.enocean.eep.a5-02-04", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_05("enocean.enocean.eep.a5-02-05", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_06("enocean.enocean.eep.a5-02-06", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_07("enocean.enocean.eep.a5-02-07", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_08("enocean.enocean.eep.a5-02-08", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_09("enocean.enocean.eep.a5-02-09", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_0A("enocean.enocean.eep.a5-02-0a", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_0B("enocean.enocean.eep.a5-02-0b", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_10("enocean.enocean.eep.a5-02-10", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_11("enocean.enocean.eep.a5-02-11", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_12("enocean.enocean.eep.a5-02-12", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_13("enocean.enocean.eep.a5-02-13", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_14("enocean.enocean.eep.a5-02-14", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_15("enocean.enocean.eep.a5-02-15", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_16("enocean.enocean.eep.a5-02-16", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_17("enocean.enocean.eep.a5-02-17", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_18("enocean.enocean.eep.a5-02-18", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_19("enocean.enocean.eep.a5-02-19", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_1A("enocean.enocean.eep.a5-02-1a", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_1B("enocean.enocean.eep.a5-02-1b", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_20("enocean.enocean.eep.a5-02-20", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_02_30("enocean.enocean.eep.a5-02-30", null, Arrays.asList("default"), GenericDevice.TEMPERATURE, Enumerations.SensorName.Temperature),
    A5_04_01("enocean.enocean.eep.a5-04-01", null, Arrays.asList("default"), GenericDevice.HUMIDITY, Enumerations.SensorName.Humidity, Enumerations.SensorName.Temperature),
    A5_04_02("enocean.enocean.eep.a5-04-02", null, Arrays.asList("default"), GenericDevice.HUMIDITY, Enumerations.SensorName.Humidity, Enumerations.SensorName.Temperature),
    A5_04_03("enocean.enocean.eep.a5-04-03", null, Arrays.asList("default"), GenericDevice.HUMIDITY, Enumerations.SensorName.Humidity, Enumerations.SensorName.Temperature),
    A5_06_01("enocean.enocean.eep.a5-06-01", null, Arrays.asList("default"), GenericDevice.BRIGHTNESS, Enumerations.SensorName.Brightness, Enumerations.SensorName.Voltage),
    A5_06_02("enocean.enocean.eep.a5-06-02", null, Arrays.asList("default"), GenericDevice.BRIGHTNESS, Enumerations.SensorName.Brightness, Enumerations.SensorName.Voltage),
    A5_06_03("enocean.enocean.eep.a5-06-03", null, Arrays.asList("default"), GenericDevice.BRIGHTNESS, Enumerations.SensorName.Brightness, Enumerations.SensorName.Voltage),
    A5_07_03("enocean.enocean.eep.a5-07-03", null, Arrays.asList("default"), GenericDevice.DETECTION, Enumerations.SensorName.Detection1, Enumerations.SensorName.Brightness, Enumerations.SensorName.Voltage),
    A5_09_04("enocean.enocean.eep.a5-09-04", null, Arrays.asList("default"), GenericDevice.GAS, Enumerations.SensorName.CO2, Enumerations.SensorName.Temperature, Enumerations.SensorName.Humidity),
    A5_10_02("enocean.enocean.eep.a5-10-02", null, Arrays.asList("default"), GenericDevice.SET_POINT, Enumerations.SensorName.SetPoint, Enumerations.SensorName.Temperature, Enumerations.SensorName.FanSpeed, Enumerations.SensorName.DayNight),
    A5_10_03("enocean.enocean.eep.a5-10-03", null, Arrays.asList("default"), GenericDevice.SET_POINT, Enumerations.SensorName.SetPoint, Enumerations.SensorName.Temperature),
    A5_10_04("enocean.enocean.eep.a5-10-04", null, Arrays.asList("default"), GenericDevice.SET_POINT, Enumerations.SensorName.SetPoint, Enumerations.SensorName.Temperature, Enumerations.SensorName.FanSpeed),
    A5_10_06("enocean.enocean.eep.a5-10-06", null, Arrays.asList("default"), GenericDevice.SET_POINT, Enumerations.SensorName.SetPoint, Enumerations.SensorName.Temperature, Enumerations.SensorName.DayNight),
    A5_10_11("enocean.enocean.eep.a5-10-11", null, Arrays.asList("default"), GenericDevice.SET_POINT, Enumerations.SensorName.SetPoint, Enumerations.SensorName.Temperature, Enumerations.SensorName.Humidity),
    A5_10_12("enocean.enocean.eep.a5-10-12", null, Arrays.asList("default"), GenericDevice.SET_POINT, Enumerations.SensorName.SetPoint, Enumerations.SensorName.Temperature, Enumerations.SensorName.Humidity),
    A5_10_22("enocean.enocean.eep.a5-10-22", null, Arrays.asList("default"), GenericDevice.SET_POINT, Enumerations.SensorName.SetPoint, Enumerations.SensorName.Temperature, Enumerations.SensorName.Humidity, Enumerations.SensorName.FanSpeed),
    A5_10_23("enocean.enocean.eep.a5-10-23", null, Arrays.asList("default"), GenericDevice.SET_POINT, Enumerations.SensorName.SetPoint, Enumerations.SensorName.Temperature, Enumerations.SensorName.Humidity, Enumerations.SensorName.FanSpeed, Enumerations.SensorName.Detection1),
    A5_14_05("enocean.enocean.eep.a5_14_05", null, Arrays.asList("default"), null, Enumerations.SensorName.Battery, Enumerations.SensorName.Detection1),
    A5_30_01("enocean.enocean.eep.a5-30-01", null, Arrays.asList("default"), null, Enumerations.SensorName.Battery, Enumerations.SensorName.Binary),
    A5_14_01("enocean.enocean.eep.a5-14-01", null, Arrays.asList("default"), GenericDevice.WINDOW, Enumerations.SensorName.Window, Enumerations.SensorName.WindowBattery),
    A5_14_09("enocean.enocean.eep.a5-14-09", null, Arrays.asList("default"), GenericDevice.WINDOW, Enumerations.SensorName.Window, Enumerations.SensorName.WindowBattery),
    A5_14_0A("enocean.enocean.eep.a5-14-0A", null, Arrays.asList("default"), null, Enumerations.SensorName.WindowAlarm, Enumerations.SensorName.Window, Enumerations.SensorName.WindowBattery),
    A5_20_01("enocean.enocean.eep.a5-20-01", null, Arrays.asList("default"), GenericDevice.SET_POINT, Enumerations.SensorName.SetPoint, Enumerations.SensorName.Temperature, Enumerations.SensorName.Valve, Enumerations.SensorName.Window, Enumerations.SensorName.Battery),
    D2_02_00("enocean.enocean.eep.d2-02-00", null, Arrays.asList("default"), GenericDevice.DETECTION, Enumerations.SensorName.Detection1, Enumerations.SensorName.Temperature, Enumerations.SensorName.Detection2, Enumerations.SensorName.Brightness),
    D2_02_01("enocean.enocean.eep.d2-02-01", null, Arrays.asList("default"), GenericDevice.DETECTION, Enumerations.SensorName.Detection1, Enumerations.SensorName.Temperature, Enumerations.SensorName.Brightness),
    D2_02_02("enocean.enocean.eep.d2-02-02", null, Arrays.asList("default"), GenericDevice.DETECTION, Enumerations.SensorName.Detection1, Enumerations.SensorName.Temperature),
    D2_14_40("enocean.enocean.eep.d2_14_40", null, Arrays.asList("default"), null, Enumerations.SensorName.Temperature, Enumerations.SensorName.Humidity, Enumerations.SensorName.Brightness, Enumerations.SensorName.Acceleration_State, Enumerations.SensorName.Acceleration_X, Enumerations.SensorName.Acceleration_Y, Enumerations.SensorName.Acceleration_Z),
    D2_14_41("enocean.enocean.eep.d2_14_41", null, Arrays.asList("default"), null, Enumerations.SensorName.Temperature, Enumerations.SensorName.Humidity, Enumerations.SensorName.Brightness, Enumerations.SensorName.Open, Enumerations.SensorName.Acceleration_State, Enumerations.SensorName.Acceleration_X, Enumerations.SensorName.Acceleration_Y, Enumerations.SensorName.Acceleration_Z),
    D2_B0_51("enocean.enocean.eep.d2-b0-51", null, Arrays.asList("default"), GenericDevice.DETECTION, Enumerations.SensorName.Detection1),
    D5_00_01("enocean.enocean.eep.d5-00-01", null, Arrays.asList("default"), GenericDevice.OPEN, Enumerations.SensorName.Open),
    F6_01_01("enocean.enocean.eep.f6-01-01", null, Arrays.asList("default"), null, Enumerations.SensorName.On),
    F6_02_01("enocean.enocean.eep.f6-02-01", null, Arrays.asList("default"), null, Enumerations.SensorName.EnergyBow, Enumerations.SensorName.RockerA, Enumerations.SensorName.RockerB),
    F6_02_02("enocean.enocean.eep.f6-02-02", null, Arrays.asList("default"), null, Enumerations.SensorName.EnergyBow, Enumerations.SensorName.RockerA, Enumerations.SensorName.RockerB),
    F6_04_01("enocean.enocean.eep.f6-04-01", null, Arrays.asList("default"), null, Enumerations.SensorName.CardSwitch),
    F6_05_01("enocean.enocean.eep.f6-05-01", null, Arrays.asList("default"), GenericDevice.DETECTION, Enumerations.SensorName.Detection1),
    F6_10_00("enocean.enocean.eep.f6-10-00", null, Arrays.asList("default"), GenericDevice.WINDOW, Enumerations.SensorName.Window),
    F6_10_01("enocean.enocean.eep.f6-10-01", null, Arrays.asList("default"), GenericDevice.WINDOW, Enumerations.SensorName.Window);

    private final String id;
    private final ArrayList<ReferenceIDs.SensorEntry> sensorIndex = new ArrayList();
    private final List<String> teachInNames;
    private final List<String> acknowledgeNames;
    private final IReferenceID superType;
    private final Set<IReferenceID> subTypes = new HashSet<IReferenceID>();

    private EEP(String id, List<String> teachInNames, List<String> acknowledgeNames, IReferenceID superType, Enumerations.SensorName ... sensorNames) {
        this(id, teachInNames, acknowledgeNames, superType);
        if (sensorNames != null) {
            for (Enumerations.SensorName sensorName : sensorNames) {
                this.sensorIndex.add(new ReferenceIDs.SensorEntry(sensorName));
            }
        }
    }

    private EEP(String id, List<String> teachInNames, List<String> acknowledgeNames, IReferenceID superType) {
        this.id = id;
        this.superType = superType;
        if (this.superType != null) {
            this.superType.registerSubType(this);
        }
        this.teachInNames = teachInNames;
        this.acknowledgeNames = acknowledgeNames;
    }

    public String toString() {
        return this.id;
    }

    public static EEP getByReferenceId(String referenceId) {
        for (EEP value : EEP.values()) {
            if (!value.getReferenceId().equalsIgnoreCase(referenceId)) continue;
            return value;
        }
        return null;
    }

    @Override
    public void registerSubType(IReferenceID subType) {
        if (subType != null) {
            this.subTypes.add(subType);
        }
    }

    @Override
    public Set<IReferenceID> getSubTypes() {
        return Collections.unmodifiableSet(this.subTypes);
    }

    @Override
    public ISensor getMainSensor(ADevice device) {
        return device.getSensorByName(this.getSensorName(0));
    }

    @Override
    public String getSensorName(int index) {
        if (index >= this.sensorIndex.size()) {
            return null;
        }
        ReferenceIDs.SensorEntry entry = this.sensorIndex.get(index);
        return entry == null ? null : entry.getName();
    }

    @Override
    public ArrayList<ReferenceIDs.SensorEntry> getSensorIndex() {
        ArrayList<ReferenceIDs.SensorEntry> result = new ArrayList<ReferenceIDs.SensorEntry>();
        result.addAll(this.sensorIndex);
        return result;
    }

    @Override
    public String getReferenceId() {
        return this.id;
    }

    @Override
    public List<String> getTeachInNames() {
        List<String> result = null;
        if (this.teachInNames != null) {
            result = Collections.unmodifiableList(this.teachInNames);
        }
        return result;
    }

    @Override
    public List<String> getAcknowledgeNames() {
        List<String> result = null;
        if (this.acknowledgeNames != null) {
            result = Collections.unmodifiableList(this.acknowledgeNames);
        }
        return result;
    }

    @Override
    public IReferenceID getSuperType() {
        return this.superType;
    }
}

