/*
 * Decompiled with CFR 0.152.
 */
package bsc.api.modules.oventrop.model;

import bsc.api.modules.oventrop.model.IModelOventrop;
import bsc.api.transport.model.ProgressStatus;
import java.util.HashMap;
import java.util.Map;

public class HydraulicBalancingTaskStatus
extends ProgressStatus
implements IModelOventrop {
    private static final long serialVersionUID = 1575654804915757481L;
    protected long startTime;
    protected long endTime;
    protected Map<String, DEVICE_STATE> deviceState;

    public HydraulicBalancingTaskStatus() {
    }

    public HydraulicBalancingTaskStatus(String progressID, Map<String, DEVICE_STATE> deviceState, long startTime) {
        this(progressID, deviceState, startTime, 0L, ProgressStatus.STATE.RUNNING);
    }

    public HydraulicBalancingTaskStatus(String progressID, Map<String, DEVICE_STATE> deviceState, long startTime, long endTime, ProgressStatus.STATE state) {
        super(progressID, state);
        this.startTime = startTime;
        this.endTime = endTime;
        this.deviceState = deviceState;
    }

    public Map<String, DEVICE_STATE> getDeviceState() {
        if (this.deviceState == null) {
            this.deviceState = new HashMap<String, DEVICE_STATE>();
        }
        return this.deviceState;
    }

    public void setDeviceState(Map<String, DEVICE_STATE> deviceState) {
        this.deviceState = deviceState;
    }

    public void putDeviceState(String deviceID, DEVICE_STATE state) {
        this.getDeviceState().put(deviceID, state);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public static enum DEVICE_STATE {
        PENDING,
        PROCESSED,
        ERROR;

    }
}

