/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.sn.storage.configuration;

import de.bscgmbh.sn.config.forms.GenericConfigurationFormField;
import de.bscgmbh.sn.storage.IExtendedFileStorage;
import de.bscgmbh.sn.storage.configuration.IStorageProviderConfiguration;
import de.bscgmbh.sn.storage.configuration.StorageProviderConfiguration;
import de.bscgmbh.sn.storage.provider.IExtendedFileStorageProviderImpl;
import de.bscgmbh.sn.storage.provider.ISimpleFileStorageProviderImpl;
import de.bscgmbh.sn.storage.provider.IStorageListEntry;
import de.bscgmbh.sn.storage.provider.StorageContentFile;
import java.util.ArrayList;

public class FileStorageProviderConfiguration
extends StorageProviderConfiguration
implements IStorageProviderConfiguration,
IExtendedFileStorage {
    protected FileStorageProviderConfiguration() {
    }

    protected FileStorageProviderConfiguration(IStorageProviderConfiguration configuration) {
        super(configuration);
    }

    public FileStorageProviderConfiguration(String id, ISimpleFileStorageProviderImpl storageProvider, ArrayList<GenericConfigurationFormField> configuration) {
        super(id, storageProvider, configuration);
    }

    @Override
    public boolean getFile(String remoteFile, String localPath) {
        IExtendedFileStorageProviderImpl provider = this.getFileStorageProvider();
        return provider == null ? false : provider.getFile(this, remoteFile, localPath);
    }

    @Override
    public boolean getFile(String remoteFile) {
        return this.getFile(remoteFile, null);
    }

    @Override
    public boolean putFile(String localFile, String remotePath) {
        IExtendedFileStorageProviderImpl provider = this.getFileStorageProvider();
        return provider == null ? false : provider.putFile(this, localFile, remotePath);
    }

    @Override
    public boolean putFile(String localFile) {
        IExtendedFileStorageProviderImpl provider = this.getFileStorageProvider();
        return provider == null ? false : provider.putFile(this, localFile);
    }

    @Override
    public boolean deleteFile(String remoteFile) {
        IExtendedFileStorageProviderImpl provider = this.getFileStorageProvider();
        return provider == null ? false : provider.deleteFile(this, remoteFile);
    }

    @Override
    public IStorageListEntry[] listFiles(String remotePath) {
        IExtendedFileStorageProviderImpl provider = this.getFileStorageProvider();
        return provider == null ? null : provider.listFiles(this, remotePath);
    }

    public IStorageListEntry[] listFiles() {
        return this.listFiles(null);
    }

    protected IExtendedFileStorageProviderImpl getFileStorageProvider() {
        if (this.storageProvider != null && this.storageProvider instanceof IExtendedFileStorageProviderImpl) {
            return (IExtendedFileStorageProviderImpl)this.storageProvider;
        }
        return null;
    }

    @Override
    public boolean isStorageAvailable() {
        IExtendedFileStorageProviderImpl provider = this.getFileStorageProvider();
        return provider == null ? null : Boolean.valueOf(provider.isStorageAvailable(this));
    }

    @Override
    public boolean moveFile(String localFile, String remotePath) {
        IExtendedFileStorageProviderImpl provider = this.getFileStorageProvider();
        return provider == null ? null : Boolean.valueOf(provider.moveFile(this, localFile, remotePath));
    }

    @Override
    public boolean moveFile(String localFile) {
        return this.moveFile(localFile, null);
    }

    @Override
    public StorageContentFile[] listContentFiles() {
        IExtendedFileStorageProviderImpl provider = this.getFileStorageProvider();
        return provider == null ? null : provider.listContentFiles(this);
    }

    @Override
    public boolean putContentFile(StorageContentFile file) {
        IExtendedFileStorageProviderImpl provider = this.getFileStorageProvider();
        return provider == null ? null : Boolean.valueOf(provider.putContentFile(this, file));
    }

    @Override
    public boolean moveContentFile(StorageContentFile file) {
        IExtendedFileStorageProviderImpl provider = this.getFileStorageProvider();
        return provider == null ? null : Boolean.valueOf(provider.moveContentFile(this, file));
    }

    @Override
    public boolean deleteContentFile(StorageContentFile file) {
        IExtendedFileStorageProviderImpl provider = this.getFileStorageProvider();
        return provider == null ? null : Boolean.valueOf(provider.deleteContentFile(this, file));
    }

    @Override
    public void initContentDirectories() {
        IExtendedFileStorageProviderImpl provider = this.getFileStorageProvider();
        if (provider != null) {
            provider.initContentDirectories(this);
        }
    }
}

