/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;

class ManagedProviderConnectionHelper
implements ConnectionHelper {
    private Properties cfgProperties;
    private StandardServiceRegistryImpl serviceRegistry;
    private Connection connection;

    public ManagedProviderConnectionHelper(Properties cfgProperties) {
        this.cfgProperties = cfgProperties;
    }

    public void prepare(boolean needsAutoCommit) throws SQLException {
        this.serviceRegistry = ManagedProviderConnectionHelper.createServiceRegistry(this.cfgProperties);
        this.connection = this.serviceRegistry.getService(ConnectionProvider.class).getConnection();
        if (needsAutoCommit && !this.connection.getAutoCommit()) {
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
    }

    private static StandardServiceRegistryImpl createServiceRegistry(Properties properties) {
        Environment.verifyProperties(properties);
        ConfigurationHelper.resolvePlaceHolders(properties);
        return (StandardServiceRegistryImpl)new StandardServiceRegistryBuilder().applySettings(properties).build();
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public void release() throws SQLException {
        try {
            this.releaseConnection();
        }
        finally {
            this.releaseServiceRegistry();
        }
    }

    private void releaseConnection() throws SQLException {
        if (this.connection != null) {
            try {
                new SqlExceptionHelper().logAndClearWarnings(this.connection);
            }
            finally {
                try {
                    this.serviceRegistry.getService(ConnectionProvider.class).closeConnection(this.connection);
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    private void releaseServiceRegistry() {
        if (this.serviceRegistry != null) {
            try {
                this.serviceRegistry.destroy();
            }
            finally {
                this.serviceRegistry = null;
            }
        }
    }
}

