/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat.internal;

import org.hibernate.HibernateException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;
import org.hibernate.stat.internal.ConcurrentStatisticsImpl;
import org.hibernate.stat.spi.StatisticsFactory;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsInitiator
implements SessionFactoryServiceInitiator<StatisticsImplementor> {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)StatisticsInitiator.class.getName());
    public static final StatisticsInitiator INSTANCE = new StatisticsInitiator();
    public static final String STATS_BUILDER = "hibernate.stats.factory";
    private static StatisticsFactory DEFAULT_STATS_BUILDER = new StatisticsFactory(){

        public StatisticsImplementor buildStatistics(SessionFactoryImplementor sessionFactory) {
            return new ConcurrentStatisticsImpl(sessionFactory);
        }
    };

    @Override
    public Class<StatisticsImplementor> getServiceInitiated() {
        return StatisticsImplementor.class;
    }

    @Override
    public StatisticsImplementor initiateService(SessionFactoryImplementor sessionFactory, Configuration configuration, ServiceRegistryImplementor registry) {
        Object configValue = configuration.getProperties().get(STATS_BUILDER);
        return this.initiateServiceInternal(sessionFactory, configValue, registry);
    }

    @Override
    public StatisticsImplementor initiateService(SessionFactoryImplementor sessionFactory, MetadataImplementor metadata, ServiceRegistryImplementor registry) {
        ConfigurationService configurationService = registry.getService(ConfigurationService.class);
        Object configValue = configurationService.getSetting(STATS_BUILDER, null);
        return this.initiateServiceInternal(sessionFactory, configValue, registry);
    }

    private StatisticsImplementor initiateServiceInternal(SessionFactoryImplementor sessionFactory, Object configValue, ServiceRegistryImplementor registry) {
        StatisticsFactory statisticsFactory;
        if (configValue == null) {
            statisticsFactory = DEFAULT_STATS_BUILDER;
        } else if (StatisticsFactory.class.isInstance(configValue)) {
            statisticsFactory = (StatisticsFactory)configValue;
        } else {
            ClassLoaderService classLoaderService = registry.getService(ClassLoaderService.class);
            try {
                statisticsFactory = (StatisticsFactory)classLoaderService.classForName(configValue.toString()).newInstance();
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HibernateException("Unable to instantiate specified StatisticsFactory implementation [" + configValue.toString() + "]", e);
            }
        }
        StatisticsImplementor statistics = statisticsFactory.buildStatistics(sessionFactory);
        boolean enabled = sessionFactory.getSettings().isStatisticsEnabled();
        statistics.setStatisticsEnabled(enabled);
        LOG.debugf("Statistics initialized [enabled=%s]", enabled);
        return statistics;
    }
}

