/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.secure.spi;

import java.util.Map;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.integrator.spi.ServiceContributingIntegrator;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.secure.internal.DisabledJaccServiceImpl;
import org.hibernate.secure.internal.JaccPreDeleteEventListener;
import org.hibernate.secure.internal.JaccPreInsertEventListener;
import org.hibernate.secure.internal.JaccPreLoadEventListener;
import org.hibernate.secure.internal.JaccPreUpdateEventListener;
import org.hibernate.secure.internal.JaccSecurityListener;
import org.hibernate.secure.internal.StandardJaccServiceImpl;
import org.hibernate.secure.spi.GrantedPermission;
import org.hibernate.secure.spi.IntegrationException;
import org.hibernate.secure.spi.JaccPermissionDeclarations;
import org.hibernate.secure.spi.JaccService;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.jboss.logging.Logger;

public class JaccIntegrator
implements ServiceContributingIntegrator {
    private static final Logger log = Logger.getLogger(JaccIntegrator.class);
    private static final DuplicationStrategy DUPLICATION_STRATEGY = new DuplicationStrategy(){

        public boolean areMatch(Object listener, Object original) {
            return listener.getClass().equals(original.getClass()) && JaccSecurityListener.class.isInstance(original);
        }

        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.KEEP_ORIGINAL;
        }
    };

    public void prepareServices(StandardServiceRegistryBuilder serviceRegistryBuilder) {
        boolean isSecurityEnabled = serviceRegistryBuilder.getSettings().containsKey("hibernate.jacc.enabled");
        JaccService jaccService = isSecurityEnabled ? new StandardJaccServiceImpl() : new DisabledJaccServiceImpl();
        serviceRegistryBuilder.addService(JaccService.class, jaccService);
    }

    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.doIntegration(configuration.getProperties(), configuration.getJaccPermissionDeclarations(), serviceRegistry);
    }

    private void doIntegration(Map properties, JaccPermissionDeclarations permissionDeclarations, SessionFactoryServiceRegistry serviceRegistry) {
        boolean isSecurityEnabled = properties.containsKey("hibernate.jacc.enabled");
        if (!isSecurityEnabled) {
            log.debug((Object)"Skipping JACC integration as it was not enabled");
            return;
        }
        String contextId = (String)properties.get("hibernate.jacc_context_id");
        if (contextId == null) {
            throw new IntegrationException("JACC context id must be specified");
        }
        JaccService jaccService = serviceRegistry.getService(JaccService.class);
        if (jaccService == null) {
            throw new IntegrationException("JaccService was not set up");
        }
        if (permissionDeclarations != null) {
            for (GrantedPermission declaration : permissionDeclarations.getPermissionDeclarations()) {
                jaccService.addPermission(declaration);
            }
        }
        EventListenerRegistry eventListenerRegistry = serviceRegistry.getService(EventListenerRegistry.class);
        eventListenerRegistry.addDuplicationStrategy(DUPLICATION_STRATEGY);
        eventListenerRegistry.prependListeners(EventType.PRE_DELETE, new JaccPreDeleteEventListener());
        eventListenerRegistry.prependListeners(EventType.PRE_INSERT, new JaccPreInsertEventListener());
        eventListenerRegistry.prependListeners(EventType.PRE_UPDATE, new JaccPreUpdateEventListener());
        eventListenerRegistry.prependListeners(EventType.PRE_LOAD, new JaccPreLoadEventListener());
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.doIntegration(sessionFactory.getProperties(), null, serviceRegistry);
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }
}

