/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import org.hibernate.EntityMode;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbCacheElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbHibernateMapping;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.Caching;
import org.hibernate.metamodel.binding.IdGenerator;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.binder.DiscriminatorSource;
import org.hibernate.metamodel.source.binder.IdentifierSource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.binder.RootEntitySource;
import org.hibernate.metamodel.source.binder.SimpleIdentifierSource;
import org.hibernate.metamodel.source.binder.SingularAttributeSource;
import org.hibernate.metamodel.source.binder.TableSource;
import org.hibernate.metamodel.source.hbm.AbstractEntitySourceImpl;
import org.hibernate.metamodel.source.hbm.ColumnAttributeSourceImpl;
import org.hibernate.metamodel.source.hbm.ColumnSourceImpl;
import org.hibernate.metamodel.source.hbm.FormulaImpl;
import org.hibernate.metamodel.source.hbm.Helper;
import org.hibernate.metamodel.source.hbm.MappingDocument;
import org.hibernate.metamodel.source.hbm.SingularIdentifierAttributeSourceImpl;
import org.hibernate.metamodel.source.hbm.TimestampAttributeSourceImpl;
import org.hibernate.metamodel.source.hbm.VersionAttributeSourceImpl;

public class RootEntitySourceImpl
extends AbstractEntitySourceImpl
implements RootEntitySource {
    protected RootEntitySourceImpl(MappingDocument sourceMappingDocument, JaxbHibernateMapping.JaxbClass entityElement) {
        super(sourceMappingDocument, entityElement);
    }

    protected JaxbHibernateMapping.JaxbClass entityElement() {
        return (JaxbHibernateMapping.JaxbClass)super.entityElement();
    }

    public IdentifierSource getIdentifierSource() {
        if (this.entityElement().getId() != null) {
            return new SimpleIdentifierSource(){

                public SingularAttributeSource getIdentifierAttributeSource() {
                    return new SingularIdentifierAttributeSourceImpl(RootEntitySourceImpl.this.entityElement().getId(), RootEntitySourceImpl.this.sourceMappingDocument().getMappingLocalBindingContext());
                }

                public IdGenerator getIdentifierGeneratorDescriptor() {
                    if (RootEntitySourceImpl.this.entityElement().getId().getGenerator() != null) {
                        String generatorName = RootEntitySourceImpl.this.entityElement().getId().getGenerator().getClazz();
                        IdGenerator idGenerator = RootEntitySourceImpl.this.sourceMappingDocument().getMappingLocalBindingContext().getMetadataImplementor().getIdGenerator(generatorName);
                        if (idGenerator == null) {
                            idGenerator = new IdGenerator(RootEntitySourceImpl.this.getEntityName() + generatorName, generatorName, Helper.extractParameters(RootEntitySourceImpl.this.entityElement().getId().getGenerator().getParam()));
                        }
                        return idGenerator;
                    }
                    return null;
                }

                public IdentifierSource.Nature getNature() {
                    return IdentifierSource.Nature.SIMPLE;
                }
            };
        }
        return null;
    }

    public SingularAttributeSource getVersioningAttributeSource() {
        if (this.entityElement().getVersion() != null) {
            return new VersionAttributeSourceImpl(this.entityElement().getVersion(), this.sourceMappingDocument().getMappingLocalBindingContext());
        }
        if (this.entityElement().getTimestamp() != null) {
            return new TimestampAttributeSourceImpl(this.entityElement().getTimestamp(), this.sourceMappingDocument().getMappingLocalBindingContext());
        }
        return null;
    }

    public EntityMode getEntityMode() {
        return this.determineEntityMode();
    }

    public boolean isMutable() {
        return this.entityElement().isMutable();
    }

    public boolean isExplicitPolymorphism() {
        return "explicit".equals(this.entityElement().getPolymorphism());
    }

    public String getWhere() {
        return this.entityElement().getWhere();
    }

    public String getRowId() {
        return this.entityElement().getRowid();
    }

    public OptimisticLockStyle getOptimisticLockStyle() {
        String optimisticLockModeString = Helper.getStringValue(this.entityElement().getOptimisticLock(), "version");
        try {
            return OptimisticLockStyle.valueOf(optimisticLockModeString.toUpperCase());
        }
        catch (Exception e) {
            throw new MappingException("Unknown optimistic-lock value : " + optimisticLockModeString, this.sourceMappingDocument().getOrigin());
        }
    }

    public Caching getCaching() {
        JaxbCacheElement cache = this.entityElement().getCache();
        if (cache == null) {
            return null;
        }
        String region = cache.getRegion() != null ? cache.getRegion() : this.getEntityName();
        AccessType accessType = Enum.valueOf(AccessType.class, cache.getUsage());
        boolean cacheLazyProps = !"non-lazy".equals(cache.getInclude());
        return new Caching(region, accessType, cacheLazyProps);
    }

    public TableSource getPrimaryTable() {
        return new TableSource(){

            public String getExplicitSchemaName() {
                return RootEntitySourceImpl.this.entityElement().getSchema();
            }

            public String getExplicitCatalogName() {
                return RootEntitySourceImpl.this.entityElement().getCatalog();
            }

            public String getExplicitTableName() {
                return RootEntitySourceImpl.this.entityElement().getTable();
            }

            public String getLogicalName() {
                return null;
            }
        };
    }

    public String getDiscriminatorMatchValue() {
        return this.entityElement().getDiscriminatorValue();
    }

    public DiscriminatorSource getDiscriminatorSource() {
        final JaxbHibernateMapping.JaxbClass.JaxbDiscriminator discriminatorElement = this.entityElement().getDiscriminator();
        if (discriminatorElement == null) {
            return null;
        }
        return new DiscriminatorSource(){

            public RelationalValueSource getDiscriminatorRelationalValueSource() {
                if (StringHelper.isNotEmpty(discriminatorElement.getColumnAttribute())) {
                    return new ColumnAttributeSourceImpl(null, discriminatorElement.getColumnAttribute(), discriminatorElement.isInsert(), discriminatorElement.isInsert());
                }
                if (StringHelper.isNotEmpty(discriminatorElement.getFormulaAttribute())) {
                    return new FormulaImpl(null, discriminatorElement.getFormulaAttribute());
                }
                if (discriminatorElement.getColumn() != null) {
                    return new ColumnSourceImpl(null, discriminatorElement.getColumn(), discriminatorElement.isInsert(), discriminatorElement.isInsert());
                }
                if (StringHelper.isNotEmpty(discriminatorElement.getFormula())) {
                    return new FormulaImpl(null, discriminatorElement.getFormula());
                }
                throw new MappingException("could not determine source of discriminator mapping", RootEntitySourceImpl.this.getOrigin());
            }

            public String getExplicitHibernateTypeName() {
                return discriminatorElement.getType();
            }

            public boolean isForced() {
                return discriminatorElement.isForce();
            }

            public boolean isInserted() {
                return discriminatorElement.isInsert();
            }
        };
    }
}

