/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.jaxb.Origin;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbFetchProfileElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbHibernateMapping;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbParamElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbQueryElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbSqlQueryElement;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.metamodel.binding.FetchProfile;
import org.hibernate.metamodel.binding.TypeDef;
import org.hibernate.metamodel.relational.AuxiliaryDatabaseObject;
import org.hibernate.metamodel.relational.BasicAuxiliaryDatabaseObjectImpl;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.hbm.HbmBindingContext;
import org.hibernate.metamodel.source.hbm.MappingDocument;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateMappingProcessor {
    private final MetadataImplementor metadata;
    private final MappingDocument mappingDocument;
    private ValueHolder<ClassLoaderService> classLoaderService = new ValueHolder<1>(new ValueHolder.DeferredInitializer<ClassLoaderService>(){

        @Override
        public ClassLoaderService initialize() {
            return HibernateMappingProcessor.this.metadata.getServiceRegistry().getService(ClassLoaderService.class);
        }
    });

    public HibernateMappingProcessor(MetadataImplementor metadata, MappingDocument mappingDocument) {
        this.metadata = metadata;
        this.mappingDocument = mappingDocument;
    }

    private JaxbHibernateMapping mappingRoot() {
        return this.mappingDocument.getMappingRoot();
    }

    private Origin origin() {
        return this.mappingDocument.getOrigin();
    }

    private HbmBindingContext bindingContext() {
        return this.mappingDocument.getMappingLocalBindingContext();
    }

    private <T> Class<T> classForName(String name) {
        return this.classLoaderService.getValue().classForName(this.bindingContext().qualifyClassName(name));
    }

    public void processIndependentMetadata() {
        this.processDatabaseObjectDefinitions();
        this.processTypeDefinitions();
    }

    private void processDatabaseObjectDefinitions() {
        if (this.mappingRoot().getDatabaseObject() == null) {
            return;
        }
        for (JaxbHibernateMapping.JaxbDatabaseObject databaseObjectElement : this.mappingRoot().getDatabaseObject()) {
            AuxiliaryDatabaseObject auxiliaryDatabaseObject;
            if (databaseObjectElement.getDefinition() != null) {
                String className = databaseObjectElement.getDefinition().getClazz();
                try {
                    auxiliaryDatabaseObject = (AuxiliaryDatabaseObject)this.classForName(className).newInstance();
                }
                catch (ClassLoadingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MappingException("could not instantiate custom database object class [" + className + "]", this.origin());
                }
            } else {
                HashSet<String> dialectScopes = new HashSet<String>();
                if (databaseObjectElement.getDialectScope() != null) {
                    for (JaxbHibernateMapping.JaxbDatabaseObject.JaxbDialectScope dialectScope : databaseObjectElement.getDialectScope()) {
                        dialectScopes.add(dialectScope.getName());
                    }
                }
                auxiliaryDatabaseObject = new BasicAuxiliaryDatabaseObjectImpl(this.metadata.getDatabase().getDefaultSchema(), databaseObjectElement.getCreate(), databaseObjectElement.getDrop(), dialectScopes);
            }
            this.metadata.getDatabase().addAuxiliaryDatabaseObject(auxiliaryDatabaseObject);
        }
    }

    private void processTypeDefinitions() {
        if (this.mappingRoot().getTypedef() == null) {
            return;
        }
        for (JaxbHibernateMapping.JaxbTypedef typedef : this.mappingRoot().getTypedef()) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (JaxbParamElement paramElement : typedef.getParam()) {
                parameters.put(paramElement.getName(), paramElement.getValue());
            }
            this.metadata.addTypeDefinition(new TypeDef(typedef.getName(), typedef.getClazz(), parameters));
        }
    }

    public void processTypeDependentMetadata() {
        this.processFilterDefinitions();
        this.processIdentifierGenerators();
    }

    private void processFilterDefinitions() {
        if (this.mappingRoot().getFilterDef() == null) {
            return;
        }
        for (JaxbHibernateMapping.JaxbFilterDef filterDefinition : this.mappingRoot().getFilterDef()) {
            String name = filterDefinition.getName();
            HashMap<String, Type> parameters = new HashMap<String, Type>();
            String condition = null;
            for (Serializable o : filterDefinition.getContent()) {
                if (o instanceof String) {
                    if (condition != null) {
                        // empty if block
                    }
                    condition = (String)((Object)o);
                    continue;
                }
                if (o instanceof JaxbHibernateMapping.JaxbFilterDef.JaxbFilterParam) {
                    JaxbHibernateMapping.JaxbFilterDef.JaxbFilterParam paramElement = (JaxbHibernateMapping.JaxbFilterDef.JaxbFilterParam)JaxbHibernateMapping.JaxbFilterDef.JaxbFilterParam.class.cast(o);
                    parameters.put(paramElement.getName(), this.metadata.getTypeResolver().heuristicType(paramElement.getType()));
                    continue;
                }
                throw new MappingException("Unrecognized nested filter content", this.origin());
            }
            if (condition == null) {
                condition = filterDefinition.getCondition();
            }
            this.metadata.addFilterDefinition(new FilterDefinition(name, condition, parameters));
        }
    }

    private void processIdentifierGenerators() {
        if (this.mappingRoot().getIdentifierGenerator() == null) {
            return;
        }
        for (JaxbHibernateMapping.JaxbIdentifierGenerator identifierGeneratorElement : this.mappingRoot().getIdentifierGenerator()) {
            this.metadata.registerIdentifierGenerator(identifierGeneratorElement.getName(), identifierGeneratorElement.getClazz());
        }
    }

    public void processMappingDependentMetadata() {
        this.processFetchProfiles();
        this.processImports();
        this.processResultSetMappings();
        this.processNamedQueries();
    }

    private void processFetchProfiles() {
        if (this.mappingRoot().getFetchProfile() == null) {
            return;
        }
        this.processFetchProfiles(this.mappingRoot().getFetchProfile(), null);
    }

    public void processFetchProfiles(List<JaxbFetchProfileElement> fetchProfiles, String containingEntityName) {
        for (JaxbFetchProfileElement fetchProfile : fetchProfiles) {
            String profileName = fetchProfile.getName();
            HashSet<FetchProfile.Fetch> fetches = new HashSet<FetchProfile.Fetch>();
            for (JaxbFetchProfileElement.JaxbFetch fetch : fetchProfile.getFetch()) {
                String entityName;
                String string = entityName = fetch.getEntity() == null ? containingEntityName : fetch.getEntity();
                if (entityName == null) {
                    throw new MappingException("could not determine entity for fetch-profile fetch [" + profileName + "]:[" + fetch.getAssociation() + "]", this.origin());
                }
                fetches.add(new FetchProfile.Fetch(entityName, fetch.getAssociation(), fetch.getStyle()));
            }
            this.metadata.addFetchProfile(new FetchProfile(profileName, fetches));
        }
    }

    private void processImports() {
        if (this.mappingRoot().getImport() == null) {
            return;
        }
        for (JaxbHibernateMapping.JaxbImport importValue : this.mappingRoot().getImport()) {
            String className = this.mappingDocument.getMappingLocalBindingContext().qualifyClassName(importValue.getClazz());
            String rename = importValue.getRename();
            rename = rename == null ? StringHelper.unqualify(className) : rename;
            this.metadata.addImport(className, rename);
        }
    }

    private void processResultSetMappings() {
        if (this.mappingRoot().getResultset() == null) {
            return;
        }
    }

    private void processNamedQueries() {
        if (this.mappingRoot().getQueryOrSqlQuery() == null) {
            return;
        }
        for (Object queryOrSqlQuery : this.mappingRoot().getQueryOrSqlQuery()) {
            if (JaxbQueryElement.class.isInstance(queryOrSqlQuery) || JaxbSqlQueryElement.class.isInstance(queryOrSqlQuery)) continue;
            throw new MappingException("unknown type of query: " + queryOrSqlQuery.getClass().getName(), this.origin());
        }
    }
}

