/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import org.hibernate.internal.jaxb.mapping.orm.JaxbAccessType;
import org.hibernate.internal.jaxb.mapping.orm.JaxbGeneratedValue;
import org.hibernate.internal.jaxb.mapping.orm.JaxbId;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.PropertyMocker;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;

class IdMocker
extends PropertyMocker {
    private JaxbId id;

    IdMocker(IndexBuilder indexBuilder, ClassInfo classInfo, EntityMappingsMocker.Default defaults, JaxbId id) {
        super(indexBuilder, classInfo, defaults);
        this.id = id;
    }

    protected void processExtra() {
        this.create(ID);
        this.parserColumn(this.id.getColumn(), this.getTarget());
        this.parserGeneratedValue(this.id.getGeneratedValue(), this.getTarget());
        this.parserTemporalType(this.id.getTemporal(), this.getTarget());
    }

    private AnnotationInstance parserGeneratedValue(JaxbGeneratedValue generatedValue, AnnotationTarget target) {
        if (generatedValue == null) {
            return null;
        }
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.stringValue("generator", generatedValue.getGenerator(), annotationValueList);
        MockHelper.enumValue("strategy", GENERATION_TYPE, generatedValue.getStrategy(), annotationValueList);
        return this.create(GENERATED_VALUE, target, annotationValueList);
    }

    protected String getFieldName() {
        return this.id.getName();
    }

    protected JaxbAccessType getAccessType() {
        return this.id.getAccess();
    }

    protected void setAccessType(JaxbAccessType accessType) {
        this.id.setAccess(accessType);
    }
}

