/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.metamodel.source.annotations.xml.filter.AbstractAnnotationFilter;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExclusiveAnnotationFilter
extends AbstractAnnotationFilter {
    public static ExclusiveAnnotationFilter INSTANCE = new ExclusiveAnnotationFilter();
    private DotName[] targetNames;
    private List<ExclusiveGroup> exclusiveGroupList = this.getExclusiveGroupList();

    private ExclusiveAnnotationFilter() {
        HashSet<DotName> names = new HashSet<DotName>();
        for (ExclusiveGroup group : this.exclusiveGroupList) {
            names.addAll(group.getNames());
        }
        this.targetNames = names.toArray(new DotName[names.size()]);
    }

    private List<ExclusiveGroup> getExclusiveGroupList() {
        if (this.exclusiveGroupList == null) {
            this.exclusiveGroupList = new ArrayList<ExclusiveGroup>();
            ExclusiveGroup group = new ExclusiveGroup();
            group.add(ENTITY);
            group.add(MAPPED_SUPERCLASS);
            group.add(EMBEDDABLE);
            group.scope = Scope.TYPE;
            this.exclusiveGroupList.add(group);
            group = new ExclusiveGroup();
            group.add(SECONDARY_TABLES);
            group.add(SECONDARY_TABLE);
            group.scope = Scope.TYPE;
            this.exclusiveGroupList.add(group);
            group = new ExclusiveGroup();
            group.add(PRIMARY_KEY_JOIN_COLUMNS);
            group.add(PRIMARY_KEY_JOIN_COLUMN);
            group.scope = Scope.ATTRIBUTE;
            this.exclusiveGroupList.add(group);
            group = new ExclusiveGroup();
            group.add(SQL_RESULT_SET_MAPPING);
            group.add(SQL_RESULT_SET_MAPPINGS);
            group.scope = Scope.TYPE;
            this.exclusiveGroupList.add(group);
            group = new ExclusiveGroup();
            group.add(NAMED_NATIVE_QUERY);
            group.add(NAMED_NATIVE_QUERIES);
            group.scope = Scope.TYPE;
            this.exclusiveGroupList.add(group);
            group = new ExclusiveGroup();
            group.add(NAMED_QUERY);
            group.add(NAMED_QUERIES);
            group.scope = Scope.TYPE;
            this.exclusiveGroupList.add(group);
            group = new ExclusiveGroup();
            group.add(ATTRIBUTE_OVERRIDES);
            group.add(ATTRIBUTE_OVERRIDE);
            group.scope = Scope.ATTRIBUTE;
            this.exclusiveGroupList.add(group);
            group = new ExclusiveGroup();
            group.add(ASSOCIATION_OVERRIDE);
            group.add(ASSOCIATION_OVERRIDES);
            group.scope = Scope.ATTRIBUTE;
            this.exclusiveGroupList.add(group);
            group = new ExclusiveGroup();
            group.add(MAP_KEY_JOIN_COLUMN);
            group.add(MAP_KEY_JOIN_COLUMNS);
            group.scope = Scope.ATTRIBUTE;
            this.exclusiveGroupList.add(group);
        }
        return this.exclusiveGroupList;
    }

    @Override
    protected void overrideIndexedAnnotationMap(DotName annName, AnnotationInstance annotationInstance, Map<DotName, List<AnnotationInstance>> map) {
        ExclusiveGroup group = this.getExclusiveGroup(annName);
        if (group == null) {
            return;
        }
        AnnotationTarget target = annotationInstance.target();
        for (DotName entityAnnName : group) {
            if (!map.containsKey(entityAnnName)) continue;
            switch (group.scope) {
                case TYPE: {
                    map.put(entityAnnName, Collections.emptyList());
                    break;
                }
                case ATTRIBUTE: {
                    List<AnnotationInstance> indexedAnnotationInstanceList = map.get(entityAnnName);
                    Iterator<AnnotationInstance> iter = indexedAnnotationInstanceList.iterator();
                    while (iter.hasNext()) {
                        AnnotationInstance ann = iter.next();
                        if (!MockHelper.targetEquals(target, ann.target())) continue;
                        iter.remove();
                    }
                    break;
                }
            }
        }
    }

    @Override
    protected DotName[] targetAnnotation() {
        return this.targetNames;
    }

    private ExclusiveGroup getExclusiveGroup(DotName annName) {
        for (ExclusiveGroup group : this.exclusiveGroupList) {
            if (!group.contains(annName)) continue;
            return group;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExclusiveGroup
    implements Iterable<DotName> {
        private Set<DotName> names = new HashSet<DotName>();
        Scope scope = Scope.ATTRIBUTE;

        private ExclusiveGroup() {
        }

        public Set<DotName> getNames() {
            return this.names;
        }

        @Override
        public Iterator iterator() {
            return this.names.iterator();
        }

        boolean contains(DotName name) {
            return this.names.contains(name);
        }

        void add(DotName name) {
            this.names.add(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Scope {
        TYPE,
        ATTRIBUTE;

    }
}

