/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute;

import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.source.annotations.attribute.AttributeOverride;
import org.hibernate.metamodel.source.annotations.attribute.BasicAttribute;
import org.hibernate.metamodel.source.annotations.attribute.ColumnValuesSourceImpl;
import org.hibernate.metamodel.source.annotations.attribute.MappedAttribute;

public class ColumnSourceImpl
extends ColumnValuesSourceImpl {
    private final MappedAttribute attribute;
    private final String name;

    ColumnSourceImpl(MappedAttribute attribute, AttributeOverride attributeOverride) {
        super(attribute.getColumnValues());
        if (attributeOverride != null) {
            this.setOverrideColumnValues(attributeOverride.getColumnValues());
        }
        this.attribute = attribute;
        this.name = this.resolveColumnName();
    }

    protected String resolveColumnName() {
        if (StringHelper.isEmpty(super.getName())) {
            return this.attribute.getContext().getNamingStrategy().propertyToColumnName(this.attribute.getName());
        }
        return super.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getReadFragment() {
        if (this.attribute instanceof BasicAttribute) {
            return ((BasicAttribute)this.attribute).getCustomReadFragment();
        }
        return null;
    }

    public String getWriteFragment() {
        if (this.attribute instanceof BasicAttribute) {
            return ((BasicAttribute)this.attribute).getCustomWriteFragment();
        }
        return null;
    }

    public String getCheckCondition() {
        if (this.attribute instanceof BasicAttribute) {
            return ((BasicAttribute)this.attribute).getCheckCondition();
        }
        return null;
    }
}

