/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.metamodel.binding.MetaAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaAttributeContext {
    private final MetaAttributeContext parentContext;
    private final ConcurrentHashMap<String, MetaAttribute> metaAttributeMap = new ConcurrentHashMap();

    public MetaAttributeContext() {
        this(null);
    }

    public MetaAttributeContext(MetaAttributeContext parentContext) {
        this.parentContext = parentContext;
    }

    public Iterable<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        this.addKeys(keys);
        return keys;
    }

    private void addKeys(Set<String> keys) {
        keys.addAll(this.metaAttributeMap.keySet());
        if (this.parentContext != null) {
            this.parentContext.addKeys(keys);
        }
    }

    public Iterable<String> getLocalKeys() {
        return this.metaAttributeMap.keySet();
    }

    public MetaAttribute getMetaAttribute(String key) {
        MetaAttribute value = this.getLocalMetaAttribute(key);
        if (value == null) {
            value = this.parentContext.getMetaAttribute(key);
        }
        return value;
    }

    public MetaAttribute getLocalMetaAttribute(String key) {
        return this.metaAttributeMap.get(key);
    }

    public void add(MetaAttribute metaAttribute) {
        this.metaAttributeMap.put(metaAttribute.getName(), metaAttribute);
    }
}

