/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.InLineView;
import org.hibernate.metamodel.relational.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Schema {
    private final Name name;
    private Map<String, InLineView> inLineViews = new HashMap<String, InLineView>();
    private Map<Identifier, Table> tables = new HashMap<Identifier, Table>();

    public Schema(Name name) {
        this.name = name;
    }

    public Schema(Identifier schema, Identifier catalog) {
        this(new Name(schema, catalog));
    }

    public Name getName() {
        return this.name;
    }

    public Table locateTable(Identifier name) {
        return this.tables.get(name);
    }

    public Table createTable(Identifier name) {
        Table table = new Table(this, name);
        this.tables.put(name, table);
        return table;
    }

    public Table locateOrCreateTable(Identifier name) {
        Table existing = this.locateTable(name);
        if (existing == null) {
            return this.createTable(name);
        }
        return existing;
    }

    public Iterable<Table> getTables() {
        return this.tables.values();
    }

    public InLineView getInLineView(String logicalName) {
        return this.inLineViews.get(logicalName);
    }

    public InLineView createInLineView(String logicalName, String subSelect) {
        InLineView inLineView = new InLineView(this, logicalName, subSelect);
        this.inLineViews.put(logicalName, inLineView);
        return inLineView;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Schema");
        sb.append("{name=").append(this.name);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema = (Schema)o;
        return !(this.name != null ? !this.name.equals(schema.name) : schema.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public static class Name {
        private final Identifier schema;
        private final Identifier catalog;

        public Name(Identifier schema, Identifier catalog) {
            this.schema = schema;
            this.catalog = catalog;
        }

        public Name(String schema, String catalog) {
            this(Identifier.toIdentifier(schema), Identifier.toIdentifier(catalog));
        }

        public Identifier getSchema() {
            return this.schema;
        }

        public Identifier getCatalog() {
            return this.catalog;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Name");
            sb.append("{schema=").append(this.schema);
            sb.append(", catalog=").append(this.catalog);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Name name = (Name)o;
            if (this.catalog != null ? !this.catalog.equals(name.catalog) : name.catalog != null) {
                return false;
            }
            return !(this.schema != null ? !this.schema.equals(name.schema) : name.schema != null);
        }

        public int hashCode() {
            int result = this.schema != null ? this.schema.hashCode() : 0;
            result = 31 * result + (this.catalog != null ? this.catalog.hashCode() : 0);
            return result;
        }
    }
}

