/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.Collections;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.relational.AbstractTableSpecification;
import org.hibernate.metamodel.relational.CheckConstraint;
import org.hibernate.metamodel.relational.Index;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.UniqueKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InLineView
extends AbstractTableSpecification {
    private final Schema schema;
    private final String logicalName;
    private final String select;

    public InLineView(Schema schema, String logicalName, String select) {
        this.schema = schema;
        this.logicalName = logicalName;
        this.select = select;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    public String getSelect() {
        return this.select;
    }

    @Override
    public String getLoggableValueQualifier() {
        return this.logicalName;
    }

    @Override
    public Iterable<Index> getIndexes() {
        return Collections.emptyList();
    }

    @Override
    public Index getOrCreateIndex(String name) {
        throw new UnsupportedOperationException("Cannot create index on inline view");
    }

    @Override
    public Iterable<UniqueKey> getUniqueKeys() {
        return Collections.emptyList();
    }

    @Override
    public UniqueKey getOrCreateUniqueKey(String name) {
        throw new UnsupportedOperationException("Cannot create unique-key on inline view");
    }

    @Override
    public Iterable<CheckConstraint> getCheckConstraints() {
        return Collections.emptyList();
    }

    @Override
    public void addCheckConstraint(String checkCondition) {
        throw new UnsupportedOperationException("Cannot create check constraint on inline view");
    }

    @Override
    public Iterable<String> getComments() {
        return Collections.emptyList();
    }

    @Override
    public void addComment(String comment) {
        throw new UnsupportedOperationException("Cannot comment on inline view");
    }

    @Override
    public String getQualifiedName(Dialect dialect) {
        return new StringBuilder(this.select.length() + 4).append("( ").append(this.select).append(" )").toString();
    }

    @Override
    public String toLoggableString() {
        return "{inline-view}";
    }
}

