/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.AssertionFailure;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Constraint;
import org.hibernate.metamodel.relational.TableSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConstraint
implements Constraint {
    private final TableSpecification table;
    private final String name;
    private List<Column> columns = new ArrayList<Column>();

    protected AbstractConstraint(TableSpecification table, String name) {
        this.table = table;
        this.name = name;
    }

    @Override
    public TableSpecification getTable() {
        return this.table;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Iterable<Column> getColumns() {
        return this.columns;
    }

    protected int getColumnSpan() {
        return this.columns.size();
    }

    protected List<Column> internalColumnAccess() {
        return this.columns;
    }

    public void addColumn(Column column) {
        this.internalAddColumn(column);
    }

    protected void internalAddColumn(Column column) {
        if (column.getTable() != this.getTable()) {
            throw new AssertionFailure(String.format("Unable to add column to constraint; tables [%s, %s] did not match", column.getTable().toLoggableString(), this.getTable().toLoggableString()));
        }
        this.columns.add(column);
    }

    protected boolean isCreationVetoed(Dialect dialect) {
        return false;
    }

    protected abstract String sqlConstraintStringInAlterTable(Dialect var1);

    @Override
    public String[] sqlDropStrings(Dialect dialect) {
        if (this.isCreationVetoed(dialect)) {
            return null;
        }
        return new String[]{"alter table " + this.getTable().getQualifiedName(dialect) + " drop constraint " + dialect.quote(this.getName())};
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) {
        if (this.isCreationVetoed(dialect)) {
            return null;
        }
        return new String[]{"alter table " + this.getTable().getQualifiedName(dialect) + this.sqlConstraintStringInAlterTable(dialect)};
    }
}

