/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaAttribute
implements Serializable {
    private final String name;
    private List<String> values = new ArrayList<String>();

    public MetaAttribute(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public String getValue() {
        if (this.values.size() != 1) {
            throw new IllegalStateException("no unique value");
        }
        return this.values.get(0);
    }

    public boolean isMultiValued() {
        return this.values.size() > 1;
    }

    public String toString() {
        return "[" + this.name + "=" + this.values + "]";
    }
}

