/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.ArrayList;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadeStyles;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.AttributeBindingContainer;
import org.hibernate.metamodel.binding.BasicAttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.SingularAssociationAttributeBinding;
import org.hibernate.metamodel.domain.SingularAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManyToOneAttributeBinding
extends BasicAttributeBinding
implements SingularAssociationAttributeBinding {
    private String referencedEntityName;
    private String referencedAttributeName;
    private AttributeBinding referencedAttributeBinding;
    private boolean isLogicalOneToOne;
    private String foreignKeyName;
    private CascadeStyle cascadeStyle;
    private FetchTiming fetchTiming;
    private FetchStyle fetchStyle;

    ManyToOneAttributeBinding(AttributeBindingContainer container, SingularAttribute attribute) {
        super(container, attribute, false, false);
    }

    @Override
    public boolean isAssociation() {
        return true;
    }

    @Override
    public final boolean isPropertyReference() {
        return this.referencedAttributeName != null;
    }

    @Override
    public final String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    @Override
    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }

    @Override
    public final String getReferencedAttributeName() {
        return this.referencedAttributeName;
    }

    @Override
    public void setReferencedAttributeName(String referencedEntityAttributeName) {
        this.referencedAttributeName = referencedEntityAttributeName;
    }

    @Override
    public CascadeStyle getCascadeStyle() {
        return this.cascadeStyle;
    }

    @Override
    public void setCascadeStyles(Iterable<CascadeStyle> cascadeStyles) {
        ArrayList<CascadeStyle> cascadeStyleList = new ArrayList<CascadeStyle>();
        for (CascadeStyle style : cascadeStyles) {
            if (style == CascadeStyles.NONE) continue;
            cascadeStyleList.add(style);
        }
        this.cascadeStyle = cascadeStyleList.isEmpty() ? CascadeStyles.NONE : (cascadeStyleList.size() == 1 ? (CascadeStyle)cascadeStyleList.get(0) : new CascadeStyles.MultipleCascadeStyle(cascadeStyleList.toArray(new CascadeStyle[cascadeStyleList.size()])));
    }

    @Override
    public FetchTiming getFetchTiming() {
        return this.fetchTiming;
    }

    @Override
    public void setFetchTiming(FetchTiming fetchTiming) {
        this.fetchTiming = fetchTiming;
    }

    @Override
    public FetchStyle getFetchStyle() {
        return this.fetchStyle;
    }

    @Override
    public void setFetchStyle(FetchStyle fetchStyle) {
        if (fetchStyle == FetchStyle.SUBSELECT) {
            throw new AssertionFailure("Subselect fetching not yet supported for singular associations");
        }
        this.fetchStyle = fetchStyle;
    }

    @Override
    public FetchMode getFetchMode() {
        if (this.fetchStyle == FetchStyle.JOIN) {
            return FetchMode.JOIN;
        }
        if (this.fetchStyle == FetchStyle.SELECT) {
            return FetchMode.SELECT;
        }
        if (this.fetchStyle == FetchStyle.BATCH) {
            return FetchMode.SELECT;
        }
        throw new AssertionFailure("Unexpected fetch style : " + this.fetchStyle.name());
    }

    @Override
    public final boolean isReferenceResolved() {
        return this.referencedAttributeBinding != null;
    }

    @Override
    public final void resolveReference(AttributeBinding referencedAttributeBinding) {
        if (!EntityBinding.class.isInstance(referencedAttributeBinding.getContainer())) {
            throw new AssertionFailure("Illegal attempt to resolve many-to-one reference based on non-entity attribute");
        }
        EntityBinding entityBinding = (EntityBinding)referencedAttributeBinding.getContainer();
        if (!this.referencedEntityName.equals(entityBinding.getEntity().getName())) {
            throw new IllegalStateException("attempt to set EntityBinding with name: [" + entityBinding.getEntity().getName() + "; entity name should be: " + this.referencedEntityName);
        }
        if (this.referencedAttributeName == null) {
            this.referencedAttributeName = referencedAttributeBinding.getAttribute().getName();
        } else if (!this.referencedAttributeName.equals(referencedAttributeBinding.getAttribute().getName())) {
            throw new IllegalStateException("Inconsistent attribute name; expected: " + this.referencedAttributeName + "actual: " + referencedAttributeBinding.getAttribute().getName());
        }
        this.referencedAttributeBinding = referencedAttributeBinding;
    }

    @Override
    public AttributeBinding getReferencedAttributeBinding() {
        if (!this.isReferenceResolved()) {
            throw new IllegalStateException("Referenced AttributeBiding has not been resolved.");
        }
        return this.referencedAttributeBinding;
    }

    @Override
    public final EntityBinding getReferencedEntityBinding() {
        return (EntityBinding)this.referencedAttributeBinding.getContainer();
    }
}

