/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.internal.util.collections.JoinedIterable;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.AttributeBindingContainer;
import org.hibernate.metamodel.binding.BagBinding;
import org.hibernate.metamodel.binding.BasicAttributeBinding;
import org.hibernate.metamodel.binding.CollectionElementNature;
import org.hibernate.metamodel.binding.ComponentAttributeBinding;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.binding.Helper;
import org.hibernate.metamodel.binding.HierarchyDetails;
import org.hibernate.metamodel.binding.InheritanceType;
import org.hibernate.metamodel.binding.ManyToOneAttributeBinding;
import org.hibernate.metamodel.binding.SetBinding;
import org.hibernate.metamodel.binding.SingularAssociationAttributeBinding;
import org.hibernate.metamodel.domain.AttributeContainer;
import org.hibernate.metamodel.domain.Entity;
import org.hibernate.metamodel.domain.PluralAttribute;
import org.hibernate.metamodel.domain.PluralAttributeNature;
import org.hibernate.metamodel.domain.SingularAttribute;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.source.MetaAttributeContext;
import org.hibernate.metamodel.source.binder.JpaCallbackClass;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.tuple.entity.EntityTuplizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityBinding
implements AttributeBindingContainer {
    private static final String NULL_DISCRIMINATOR_MATCH_VALUE = "null";
    private static final String NOT_NULL_DISCRIMINATOR_MATCH_VALUE = "not null";
    private final EntityBinding superEntityBinding;
    private final List<EntityBinding> subEntityBindings = new ArrayList<EntityBinding>();
    private final HierarchyDetails hierarchyDetails;
    private Entity entity;
    private TableSpecification primaryTable;
    private String primaryTableName;
    private Map<String, TableSpecification> secondaryTables = new HashMap<String, TableSpecification>();
    private ValueHolder<Class<?>> proxyInterfaceType;
    private String jpaEntityName;
    private Class<? extends EntityPersister> customEntityPersisterClass;
    private Class<? extends EntityTuplizer> customEntityTuplizerClass;
    private String discriminatorMatchValue;
    private Set<FilterDefinition> filterDefinitions = new HashSet<FilterDefinition>();
    private Set<SingularAssociationAttributeBinding> entityReferencingAttributeBindings = new HashSet<SingularAssociationAttributeBinding>();
    private MetaAttributeContext metaAttributeContext;
    private boolean lazy;
    private boolean mutable;
    private String whereFilter;
    private String rowId;
    private boolean dynamicUpdate;
    private boolean dynamicInsert;
    private int batchSize;
    private boolean selectBeforeUpdate;
    private boolean hasSubselectLoadableCollections;
    private Boolean isAbstract;
    private String customLoaderName;
    private CustomSQL customInsert;
    private CustomSQL customUpdate;
    private CustomSQL customDelete;
    private Set<String> synchronizedTableNames = new HashSet<String>();
    private Map<String, AttributeBinding> attributeBindingMap = new HashMap<String, AttributeBinding>();
    private List<JpaCallbackClass> jpaCallbackClasses = new ArrayList<JpaCallbackClass>();

    public EntityBinding(InheritanceType inheritanceType, EntityMode entityMode) {
        this.superEntityBinding = null;
        this.hierarchyDetails = new HierarchyDetails(this, inheritanceType, entityMode);
    }

    public EntityBinding(EntityBinding superEntityBinding) {
        this.superEntityBinding = superEntityBinding;
        this.superEntityBinding.subEntityBindings.add(this);
        this.hierarchyDetails = superEntityBinding.getHierarchyDetails();
    }

    public HierarchyDetails getHierarchyDetails() {
        return this.hierarchyDetails;
    }

    public EntityBinding getSuperEntityBinding() {
        return this.superEntityBinding;
    }

    public boolean isRoot() {
        return this.superEntityBinding == null;
    }

    public boolean isPolymorphic() {
        return this.superEntityBinding != null || this.hierarchyDetails.getEntityDiscriminator() != null || !this.subEntityBindings.isEmpty();
    }

    public boolean hasSubEntityBindings() {
        return this.subEntityBindings.size() > 0;
    }

    public int getSubEntityBindingClosureSpan() {
        int n = this.subEntityBindings.size();
        for (EntityBinding subEntityBinding : this.subEntityBindings) {
            n += subEntityBinding.getSubEntityBindingClosureSpan();
        }
        return n;
    }

    public Iterable<EntityBinding> getDirectSubEntityBindings() {
        return this.subEntityBindings;
    }

    public Iterable<EntityBinding> getPostOrderSubEntityBindingClosure() {
        ArrayList subclassIterables = new ArrayList(this.subEntityBindings.size() + 1);
        for (EntityBinding subEntityBinding : this.subEntityBindings) {
            Iterable<EntityBinding> subSubEntityBindings = subEntityBinding.getPostOrderSubEntityBindingClosure();
            if (!subSubEntityBindings.iterator().hasNext()) continue;
            subclassIterables.add(subSubEntityBindings);
        }
        if (!this.subEntityBindings.isEmpty()) {
            subclassIterables.add(this.subEntityBindings);
        }
        return new JoinedIterable<EntityBinding>(subclassIterables);
    }

    public Iterable<EntityBinding> getPreOrderSubEntityBindingClosure() {
        return this.getPreOrderSubEntityBindingClosure(false);
    }

    private Iterable<EntityBinding> getPreOrderSubEntityBindingClosure(boolean includeThis) {
        ArrayList iterables = new ArrayList();
        if (includeThis) {
            iterables.add(Collections.singletonList(this));
        }
        for (EntityBinding subEntityBinding : this.subEntityBindings) {
            Iterable<EntityBinding> subSubEntityBindingClosure = subEntityBinding.getPreOrderSubEntityBindingClosure(true);
            if (!subSubEntityBindingClosure.iterator().hasNext()) continue;
            iterables.add(subSubEntityBindingClosure);
        }
        return new JoinedIterable<EntityBinding>(iterables);
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public TableSpecification getPrimaryTable() {
        return this.primaryTable;
    }

    public void setPrimaryTable(TableSpecification primaryTable) {
        this.primaryTable = primaryTable;
    }

    public TableSpecification locateTable(String tableName) {
        if (tableName == null || tableName.equals(this.getPrimaryTableName())) {
            return this.primaryTable;
        }
        TableSpecification tableSpec = this.secondaryTables.get(tableName);
        if (tableSpec == null) {
            throw new AssertionFailure(String.format("Unable to find table %s amongst tables %s", tableName, this.secondaryTables.keySet()));
        }
        return tableSpec;
    }

    public String getPrimaryTableName() {
        return this.primaryTableName;
    }

    public void setPrimaryTableName(String primaryTableName) {
        this.primaryTableName = primaryTableName;
    }

    public void addSecondaryTable(String tableName, TableSpecification table) {
        this.secondaryTables.put(tableName, table);
    }

    public boolean isVersioned() {
        return this.getHierarchyDetails().getVersioningAttributeBinding() != null;
    }

    public boolean isDiscriminatorMatchValueNull() {
        return NULL_DISCRIMINATOR_MATCH_VALUE.equals(this.discriminatorMatchValue);
    }

    public boolean isDiscriminatorMatchValueNotNull() {
        return NOT_NULL_DISCRIMINATOR_MATCH_VALUE.equals(this.discriminatorMatchValue);
    }

    public String getDiscriminatorMatchValue() {
        return this.discriminatorMatchValue;
    }

    public void setDiscriminatorMatchValue(String discriminatorMatchValue) {
        this.discriminatorMatchValue = discriminatorMatchValue;
    }

    public Iterable<FilterDefinition> getFilterDefinitions() {
        return this.filterDefinitions;
    }

    public void addFilterDefinition(FilterDefinition filterDefinition) {
        this.filterDefinitions.add(filterDefinition);
    }

    public Iterable<SingularAssociationAttributeBinding> getEntityReferencingAttributeBindings() {
        return this.entityReferencingAttributeBindings;
    }

    @Override
    public EntityBinding seekEntityBinding() {
        return this;
    }

    @Override
    public String getPathBase() {
        return this.getEntity().getName();
    }

    @Override
    public Class<?> getClassReference() {
        return this.getEntity().getClassReference();
    }

    @Override
    public AttributeContainer getAttributeContainer() {
        return this.getEntity();
    }

    protected void registerAttributeBinding(String name, AttributeBinding attributeBinding) {
        if (SingularAssociationAttributeBinding.class.isInstance(attributeBinding)) {
            this.entityReferencingAttributeBindings.add((SingularAssociationAttributeBinding)attributeBinding);
        }
        this.attributeBindingMap.put(name, attributeBinding);
    }

    @Override
    public MetaAttributeContext getMetaAttributeContext() {
        return this.metaAttributeContext;
    }

    public void setMetaAttributeContext(MetaAttributeContext metaAttributeContext) {
        this.metaAttributeContext = metaAttributeContext;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public ValueHolder<Class<?>> getProxyInterfaceType() {
        return this.proxyInterfaceType;
    }

    public void setProxyInterfaceType(ValueHolder<Class<?>> proxyInterfaceType) {
        this.proxyInterfaceType = proxyInterfaceType;
    }

    public String getWhereFilter() {
        return this.whereFilter;
    }

    public void setWhereFilter(String whereFilter) {
        this.whereFilter = whereFilter;
    }

    public String getRowId() {
        return this.rowId;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public boolean isDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public void setDynamicUpdate(boolean dynamicUpdate) {
        this.dynamicUpdate = dynamicUpdate;
    }

    public boolean isDynamicInsert() {
        return this.dynamicInsert;
    }

    public void setDynamicInsert(boolean dynamicInsert) {
        this.dynamicInsert = dynamicInsert;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    public void setSelectBeforeUpdate(boolean selectBeforeUpdate) {
        this.selectBeforeUpdate = selectBeforeUpdate;
    }

    public boolean hasSubselectLoadableCollections() {
        return this.hasSubselectLoadableCollections;
    }

    void setSubselectLoadableCollections(boolean hasSubselectLoadableCollections) {
        this.hasSubselectLoadableCollections = hasSubselectLoadableCollections;
    }

    public Class<? extends EntityPersister> getCustomEntityPersisterClass() {
        return this.customEntityPersisterClass;
    }

    public void setCustomEntityPersisterClass(Class<? extends EntityPersister> customEntityPersisterClass) {
        this.customEntityPersisterClass = customEntityPersisterClass;
    }

    public Class<? extends EntityTuplizer> getCustomEntityTuplizerClass() {
        return this.customEntityTuplizerClass;
    }

    public void setCustomEntityTuplizerClass(Class<? extends EntityTuplizer> customEntityTuplizerClass) {
        this.customEntityTuplizerClass = customEntityTuplizerClass;
    }

    public Boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(Boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public Set<String> getSynchronizedTableNames() {
        return this.synchronizedTableNames;
    }

    public void addSynchronizedTableNames(Collection<String> synchronizedTableNames) {
        this.synchronizedTableNames.addAll(synchronizedTableNames);
    }

    public String getJpaEntityName() {
        return this.jpaEntityName;
    }

    public void setJpaEntityName(String jpaEntityName) {
        this.jpaEntityName = jpaEntityName;
    }

    public String getCustomLoaderName() {
        return this.customLoaderName;
    }

    public void setCustomLoaderName(String customLoaderName) {
        this.customLoaderName = customLoaderName;
    }

    public CustomSQL getCustomInsert() {
        return this.customInsert;
    }

    public void setCustomInsert(CustomSQL customInsert) {
        this.customInsert = customInsert;
    }

    public CustomSQL getCustomUpdate() {
        return this.customUpdate;
    }

    public void setCustomUpdate(CustomSQL customUpdate) {
        this.customUpdate = customUpdate;
    }

    public CustomSQL getCustomDelete() {
        return this.customDelete;
    }

    public void setCustomDelete(CustomSQL customDelete) {
        this.customDelete = customDelete;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EntityBinding");
        sb.append("{entity=").append(this.entity != null ? this.entity.getName() : "not set");
        sb.append('}');
        return sb.toString();
    }

    @Override
    public BasicAttributeBinding makeBasicAttributeBinding(SingularAttribute attribute) {
        return this.makeSimpleAttributeBinding(attribute, false, false);
    }

    private BasicAttributeBinding makeSimpleAttributeBinding(SingularAttribute attribute, boolean forceNonNullable, boolean forceUnique) {
        BasicAttributeBinding binding = new BasicAttributeBinding(this, attribute, forceNonNullable, forceUnique);
        this.registerAttributeBinding(attribute.getName(), binding);
        return binding;
    }

    @Override
    public ComponentAttributeBinding makeComponentAttributeBinding(SingularAttribute attribute) {
        ComponentAttributeBinding binding = new ComponentAttributeBinding((AttributeBindingContainer)this, attribute);
        this.registerAttributeBinding(attribute.getName(), binding);
        return binding;
    }

    @Override
    public ManyToOneAttributeBinding makeManyToOneAttributeBinding(SingularAttribute attribute) {
        ManyToOneAttributeBinding binding = new ManyToOneAttributeBinding((AttributeBindingContainer)this, attribute);
        this.registerAttributeBinding(attribute.getName(), binding);
        return binding;
    }

    @Override
    public BagBinding makeBagAttributeBinding(PluralAttribute attribute, CollectionElementNature nature) {
        Helper.checkPluralAttributeNature(attribute, PluralAttributeNature.BAG);
        BagBinding binding = new BagBinding(this, attribute, nature);
        this.registerAttributeBinding(attribute.getName(), binding);
        return binding;
    }

    @Override
    public SetBinding makeSetAttributeBinding(PluralAttribute attribute, CollectionElementNature nature) {
        Helper.checkPluralAttributeNature(attribute, PluralAttributeNature.SET);
        SetBinding binding = new SetBinding(this, attribute, nature);
        this.registerAttributeBinding(attribute.getName(), binding);
        return binding;
    }

    @Override
    public AttributeBinding locateAttributeBinding(String name) {
        return this.attributeBindingMap.get(name);
    }

    @Override
    public Iterable<AttributeBinding> attributeBindings() {
        return this.attributeBindingMap.values();
    }

    public int getAttributeBindingClosureSpan() {
        return this.superEntityBinding != null ? this.superEntityBinding.getAttributeBindingClosureSpan() + this.attributeBindingMap.size() : this.attributeBindingMap.size();
    }

    public Iterable<AttributeBinding> getAttributeBindingClosure() {
        Iterable<AttributeBinding> iterable;
        if (this.superEntityBinding != null) {
            ArrayList iterables = new ArrayList(2);
            iterables.add(this.superEntityBinding.getAttributeBindingClosure());
            iterables.add(this.attributeBindings());
            iterable = new JoinedIterable<AttributeBinding>(iterables);
        } else {
            iterable = this.attributeBindings();
        }
        return iterable;
    }

    public Iterable<AttributeBinding> getSubEntityAttributeBindingClosure() {
        ArrayList iterables = new ArrayList();
        iterables.add(this.getAttributeBindingClosure());
        for (EntityBinding subEntityBinding : this.getPreOrderSubEntityBindingClosure()) {
            iterables.add(subEntityBinding.attributeBindings());
        }
        return new JoinedIterable<AttributeBinding>(iterables);
    }

    public void setJpaCallbackClasses(List<JpaCallbackClass> jpaCallbackClasses) {
        this.jpaCallbackClasses = jpaCallbackClasses;
    }

    public Iterable<JpaCallbackClass> getJpaCallbackClasses() {
        return this.jpaCallbackClasses;
    }
}

