/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.AbstractQueryImpl;

public class QueryImpl
extends AbstractQueryImpl {
    private LockOptions lockOptions = new LockOptions();

    public QueryImpl(String queryString, FlushMode flushMode, SessionImplementor session, ParameterMetadata parameterMetadata) {
        super(queryString, flushMode, session, parameterMetadata);
    }

    public QueryImpl(String queryString, SessionImplementor session, ParameterMetadata parameterMetadata) {
        this(queryString, null, session, parameterMetadata);
    }

    public Iterator iterate() throws HibernateException {
        this.verifyParameters();
        Map<String, TypedValue> namedParams = this.getNamedParams();
        this.before();
        try {
            Iterator iterator = this.getSession().iterate(this.expandParameterLists(namedParams), this.getQueryParameters(namedParams));
            return iterator;
        }
        finally {
            this.after();
        }
    }

    public ScrollableResults scroll() throws HibernateException {
        return this.scroll(this.session.getFactory().getDialect().defaultScrollMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
        this.verifyParameters();
        Map<String, TypedValue> namedParams = this.getNamedParams();
        this.before();
        QueryParameters qp = this.getQueryParameters(namedParams);
        qp.setScrollMode(scrollMode);
        try {
            ScrollableResults scrollableResults = this.getSession().scroll(this.expandParameterLists(namedParams), qp);
            return scrollableResults;
        }
        finally {
            this.after();
        }
    }

    public List list() throws HibernateException {
        this.verifyParameters();
        Map<String, TypedValue> namedParams = this.getNamedParams();
        this.before();
        try {
            List list = this.getSession().list(this.expandParameterLists(namedParams), this.getQueryParameters(namedParams));
            return list;
        }
        finally {
            this.after();
        }
    }

    public int executeUpdate() throws HibernateException {
        this.verifyParameters();
        Map<String, TypedValue> namedParams = this.getNamedParams();
        this.before();
        try {
            int n = this.getSession().executeUpdate(this.expandParameterLists(namedParams), this.getQueryParameters(namedParams));
            return n;
        }
        finally {
            this.after();
        }
    }

    public Query setLockMode(String alias, LockMode lockMode) {
        this.lockOptions.setAliasSpecificLockMode(alias, lockMode);
        return this;
    }

    public Query setLockOptions(LockOptions lockOption) {
        this.lockOptions.setLockMode(lockOption.getLockMode());
        this.lockOptions.setScope(lockOption.getScope());
        this.lockOptions.setTimeOut(lockOption.getTimeOut());
        return this;
    }

    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    public boolean isSelect() {
        return this.getSession().getFactory().getQueryPlanCache().getHQLQueryPlan(this.getQueryString(), false, Collections.<String, Filter>emptyMap()).isSelect();
    }
}

