/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import org.hibernate.BasicQueryContract;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionImplementor;

public abstract class AbstractBasicQueryContractImpl
implements BasicQueryContract {
    private final SessionImplementor session;
    private FlushMode flushMode;
    private CacheMode cacheMode;
    private boolean cacheable;
    private String cacheRegion;
    private boolean readOnly;
    private RowSelection selection = new RowSelection();

    protected AbstractBasicQueryContractImpl(SessionImplementor session) {
        this.session = session;
        this.readOnly = session.getPersistenceContext().isDefaultReadOnly();
    }

    protected SessionImplementor session() {
        return this.session;
    }

    public FlushMode getFlushMode() {
        return this.flushMode;
    }

    public BasicQueryContract setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public BasicQueryContract setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public BasicQueryContract setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public String getCacheRegion() {
        return this.cacheRegion;
    }

    public BasicQueryContract setCacheRegion(String cacheRegion) {
        if (cacheRegion != null) {
            this.cacheRegion = cacheRegion.trim();
        }
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public BasicQueryContract setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public Integer getTimeout() {
        return this.selection.getTimeout();
    }

    public BasicQueryContract setTimeout(int timeout) {
        this.selection.setTimeout(timeout);
        return this;
    }

    public Integer getFetchSize() {
        return this.selection.getFetchSize();
    }

    public BasicQueryContract setFetchSize(int fetchSize) {
        this.selection.setFetchSize(fetchSize);
        return this;
    }

    public QueryParameters buildQueryParametersObject() {
        QueryParameters qp = new QueryParameters();
        qp.setRowSelection(this.selection);
        qp.setCacheable(this.cacheable);
        qp.setCacheRegion(this.cacheRegion);
        qp.setReadOnly(this.readOnly);
        return qp;
    }
}

