/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.synchronization.internal;

import org.hibernate.HibernateException;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.synchronization.internal.SynchronizationCallbackCoordinatorNonTrackingImpl;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class SynchronizationCallbackCoordinatorTrackingImpl
extends SynchronizationCallbackCoordinatorNonTrackingImpl {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(SynchronizationCallbackCoordinatorTrackingImpl.class);
    private static final int NO_STATUS = -1;
    private volatile long registrationThreadId;
    private volatile int delayedCompletionHandlingStatus;

    public SynchronizationCallbackCoordinatorTrackingImpl(TransactionCoordinator transactionCoordinator) {
        super(transactionCoordinator);
    }

    public void reset() {
        super.reset();
        this.delayedCompletionHandlingStatus = -1;
    }

    public void afterCompletion(int status) {
        if (JtaStatusHelper.isRollback(status)) {
            boolean isRegistrationThread;
            long currentThreadId = Thread.currentThread().getId();
            boolean bl = isRegistrationThread = currentThreadId == this.registrationThreadId;
            if (!isRegistrationThread) {
                this.delayedCompletionHandlingStatus = status;
                this.transactionCoordinator().getJdbcCoordinator().getLogicalConnection().close();
                log.rollbackFromBackgroundThread(status);
                return;
            }
        }
        this.doAfterCompletion(status);
    }

    public void synchronizationRegistered() {
        this.registrationThreadId = Thread.currentThread().getId();
    }

    public void processAnyDelayedAfterCompletion() {
        if (this.delayedCompletionHandlingStatus != -1) {
            this.doAfterCompletion(this.delayedCompletionHandlingStatus);
            this.delayedCompletionHandlingStatus = -1;
            throw new HibernateException("Transaction was rolled back in a different thread!");
        }
    }
}

