/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query.spi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.QueryParameterException;
import org.hibernate.engine.query.spi.NamedParameterDescriptor;
import org.hibernate.engine.query.spi.OrdinalParameterDescriptor;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterMetadata
implements Serializable {
    private static final OrdinalParameterDescriptor[] EMPTY_ORDINALS = new OrdinalParameterDescriptor[0];
    private final OrdinalParameterDescriptor[] ordinalDescriptors;
    private final Map<String, NamedParameterDescriptor> namedDescriptorMap;

    public ParameterMetadata(OrdinalParameterDescriptor[] ordinalDescriptors, Map<String, NamedParameterDescriptor> namedDescriptorMap) {
        if (ordinalDescriptors == null) {
            this.ordinalDescriptors = EMPTY_ORDINALS;
        } else {
            OrdinalParameterDescriptor[] copy = new OrdinalParameterDescriptor[ordinalDescriptors.length];
            System.arraycopy(ordinalDescriptors, 0, copy, 0, ordinalDescriptors.length);
            this.ordinalDescriptors = copy;
        }
        if (namedDescriptorMap == null) {
            this.namedDescriptorMap = Collections.emptyMap();
        } else {
            int size = (int)((double)namedDescriptorMap.size() / 0.75 + 1.0);
            HashMap<String, NamedParameterDescriptor> copy = new HashMap<String, NamedParameterDescriptor>(size);
            copy.putAll(namedDescriptorMap);
            this.namedDescriptorMap = Collections.unmodifiableMap(copy);
        }
    }

    public int getOrdinalParameterCount() {
        return this.ordinalDescriptors.length;
    }

    public OrdinalParameterDescriptor getOrdinalParameterDescriptor(int position) {
        if (position < 1 || position > this.ordinalDescriptors.length) {
            throw new QueryParameterException("Position beyond number of declared ordinal parameters. Remember that ordinal parameters are 1-based! Position: " + position);
        }
        return this.ordinalDescriptors[position - 1];
    }

    @Deprecated
    public Type getOrdinalParameterExpectedType(int position) {
        return this.getOrdinalParameterDescriptor(position).getExpectedType();
    }

    @Deprecated
    public int getOrdinalParameterSourceLocation(int position) {
        return this.getOrdinalParameterDescriptor(position).getSourceLocation();
    }

    public Set<String> getNamedParameterNames() {
        return this.namedDescriptorMap.keySet();
    }

    public NamedParameterDescriptor getNamedParameterDescriptor(String name) {
        NamedParameterDescriptor meta = this.namedDescriptorMap.get(name);
        if (meta == null) {
            throw new QueryParameterException("could not locate named parameter [" + name + "]");
        }
        return meta;
    }

    @Deprecated
    public Type getNamedParameterExpectedType(String name) {
        return this.getNamedParameterDescriptor(name).getExpectedType();
    }

    @Deprecated
    public int[] getNamedParameterSourceLocations(String name) {
        return this.getNamedParameterDescriptor(name).getSourceLocations();
    }
}

