/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.util.Locale;
import org.hibernate.MappingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FlushMode {
    NEVER(0),
    MANUAL(0),
    COMMIT(5),
    AUTO(10),
    ALWAYS(20);

    private final int level;

    private FlushMode(int level) {
        this.level = level;
    }

    public boolean lessThan(FlushMode other) {
        return this.level < other.level;
    }

    @Deprecated
    public static boolean isManualFlushMode(FlushMode mode) {
        return FlushMode.MANUAL.level == mode.level;
    }

    public static FlushMode interpretExternalSetting(String externalName) {
        if (externalName == null) {
            return null;
        }
        try {
            return FlushMode.valueOf(externalName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new MappingException("unknown FlushMode : " + externalName);
        }
    }
}

