/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final Excluder excluder;
    private Gson context;
    private TypeToken<?> type;

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingPolicy, Excluder excluder) {
        this.constructorConstructor = constructorConstructor;
        this.fieldNamingPolicy = fieldNamingPolicy;
        this.excluder = excluder;
    }

    public boolean excludeField(Field f, boolean serialize) {
        return !this.excluder.excludeClass(f.getType(), serialize) && !this.excluder.excludeField(f, serialize);
    }

    private String getFieldName(Field f) {
        SerializedName serializedName = f.getAnnotation(SerializedName.class);
        return serializedName == null ? this.fieldNamingPolicy.translateName(f) : serializedName.value();
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        this.context = gson;
        this.type = type;
        Class<T> raw = type.getRawType();
        if (!Object.class.isAssignableFrom(raw)) {
            return null;
        }
        Map<String, BoundField> boundFields = this.getBoundFields(gson, type, raw);
        ObjectConstructor<T> constructor = this.constructorConstructor.get(type);
        return new Adapter(constructor, this.constructorConstructor, boundFields);
    }

    private BoundField createBoundField(final Gson context, final Field field, String name, final TypeToken<?> fieldType, boolean serialize, boolean deserialize) {
        final boolean isPrimitive = Primitives.isPrimitive(fieldType.getRawType());
        return new BoundField(name, serialize, deserialize){
            final TypeAdapter<?> typeAdapter;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.typeAdapter = gson.getAdapter(typeToken);
            }

            @Override
            void write(JsonWriter writer, Object value) throws IOException, IllegalAccessException {
                Object fieldValue = field.get(value);
                TypeAdapterRuntimeTypeWrapper t = new TypeAdapterRuntimeTypeWrapper(context, this.typeAdapter, fieldType.getType());
                ((TypeAdapter)t).write(writer, fieldValue);
            }

            @Override
            void read(JsonReader reader, Object value) throws IOException, IllegalAccessException {
                Object fieldValue = this.typeAdapter.read(reader);
                if (fieldValue != null || !isPrimitive) {
                    field.set(value, fieldValue);
                }
            }
        };
    }

    private Map<String, BoundField> getBoundFields(Gson context, TypeToken<?> type, Class<?> raw) {
        LinkedHashMap<String, BoundField> result = new LinkedHashMap<String, BoundField>();
        if (raw.isInterface()) {
            return result;
        }
        Type declaredType = type.getType();
        while (raw != Object.class) {
            Field[] fields;
            Field[] fieldArray = fields = raw.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                boolean serialize = this.excludeField(field, true);
                boolean deserialize = this.excludeField(field, false);
                if (serialize || deserialize) {
                    field.setAccessible(true);
                    Type fieldType = $Gson$Types.resolve(type.getType(), raw, field.getGenericType());
                    BoundField boundField = this.createBoundField(context, field, this.getFieldName(field), TypeToken.get(fieldType), serialize, deserialize);
                    BoundField previous = result.put(boundField.name, boundField);
                    if (previous != null) {
                        throw new IllegalArgumentException(declaredType + " declares multiple JSON fields named " + previous.name);
                    }
                }
                ++n2;
            }
            type = TypeToken.get($Gson$Types.resolve(type.getType(), raw, raw.getGenericSuperclass()));
            raw = type.getRawType();
        }
        return result;
    }

    public final class Adapter<T>
    extends TypeAdapter<T> {
        private static final String CLASSNAME = "ClassNameExt";
        private final ObjectConstructor<T> constructor;
        private final ConstructorConstructor constructorConstructor;
        private final Map<String, BoundField> boundFields;

        private Adapter(ObjectConstructor<T> constructor, ConstructorConstructor constructorConstructor, Map<String, BoundField> boundFields) {
            this.constructor = constructor;
            this.constructorConstructor = constructorConstructor;
            this.boundFields = boundFields;
        }

        @Override
        public T read(JsonReader in) throws IOException {
            T instance;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            try {
                ObjectConstructor<Object> constructor;
                Map boundFields;
                in.beginObject();
                if (ReflectiveTypeAdapterFactory.this.context.isEnableObjectClassNames()) {
                    String property = in.nextName();
                    if (property == null || !property.equals(CLASSNAME)) {
                        throw new IOException("Unable to create object. No ClassName property found.");
                    }
                    String className = in.nextString();
                    if (className == null) {
                        throw new IOException("Unable to create object. ClassName property is null.");
                    }
                    try {
                        Class<?> clazz = Class.forName(className);
                        boundFields = ReflectiveTypeAdapterFactory.this.getBoundFields(ReflectiveTypeAdapterFactory.this.context, ReflectiveTypeAdapterFactory.this.type, clazz);
                        constructor = this.constructorConstructor.get(TypeToken.get(clazz));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new IOException("Unable to create object for class " + className + ".");
                    }
                } else {
                    constructor = this.constructor;
                    boundFields = this.boundFields;
                }
                instance = constructor.construct();
                while (in.hasNext()) {
                    String name = in.nextName();
                    BoundField field = boundFields.get(name);
                    if (field == null || !field.deserialized) {
                        in.skipValue();
                        continue;
                    }
                    field.read(in, instance);
                }
            }
            catch (IllegalStateException e) {
                throw new JsonSyntaxException(e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            in.endObject();
            return instance;
        }

        @Override
        public void write(JsonWriter out, T value) throws IOException {
            Map boundFields;
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            if (ReflectiveTypeAdapterFactory.this.context.isEnableObjectClassNames()) {
                out.name(CLASSNAME);
                out.value(value.getClass().getName());
                boundFields = ReflectiveTypeAdapterFactory.this.getBoundFields(ReflectiveTypeAdapterFactory.this.context, ReflectiveTypeAdapterFactory.this.type, value.getClass());
            } else {
                boundFields = this.boundFields;
            }
            try {
                for (BoundField boundField : boundFields.values()) {
                    if (!boundField.serialized) continue;
                    out.name(boundField.name);
                    boundField.write(out, value);
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
            out.endObject();
        }
    }

    static abstract class BoundField {
        final String name;
        final boolean serialized;
        final boolean deserialized;

        protected BoundField(String name, boolean serialized, boolean deserialized) {
            this.name = name;
            this.serialized = serialized;
            this.deserialized = deserialized;
        }

        abstract void write(JsonWriter var1, Object var2) throws IOException, IllegalAccessException;

        abstract void read(JsonReader var1, Object var2) throws IOException, IllegalAccessException;
    }
}

