/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class BackupLogs {
    private String configDatei = "BackupLogs.cfg";
    private String logsQuelle = "/var/lib/Home-Controller/logs";
    private String logsZiel = "/var/lib/Home-Controller/logs";
    private long maxOrdnerGroesse = 512000000L;
    private String backupLogs = "backupLogs";
    private Properties einstellungen;
    private SimpleDateFormat dateFormatalt = new SimpleDateFormat("dd-MM-yyyy");
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    private BackupLogs() {
        if (this.init() && this.cleanUpOldLogs()) {
            this.compressOldLogs();
        }
    }

    private boolean init() {
        File config = new File(this.configDatei);
        if (config.exists()) {
            this.einstellungen = new Properties();
            try {
                long tmpmaxOrdnerGroesse;
                String tmplogsZiel;
                String tmplogsQuelle;
                this.einstellungen.load(new FileInputStream(this.configDatei));
                String tmpbackupLogs = this.einstellungen.getProperty("backupLogs");
                if (tmpbackupLogs != null && tmpbackupLogs != "") {
                    this.backupLogs = tmpbackupLogs.replace("\"", "");
                }
                if ((tmplogsQuelle = this.einstellungen.getProperty("logsQuelle")) != null && tmplogsQuelle != "") {
                    this.logsQuelle = tmplogsQuelle.replace("\"", "");
                }
                if ((tmplogsZiel = this.einstellungen.getProperty("logsZiel")) != null && tmplogsZiel != "") {
                    this.logsZiel = tmplogsZiel.replace("\"", "");
                }
                if ((tmpmaxOrdnerGroesse = Long.parseLong(this.einstellungen.getProperty("maxOrdnerGroesse"))) > 1024000L) {
                    this.maxOrdnerGroesse = tmpmaxOrdnerGroesse;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        this.logsZiel = String.valueOf(this.logsZiel) + "/" + this.backupLogs;
        File f = new File(this.logsZiel);
        return f.exists() || f.mkdirs();
    }

    private void compressOldLogs() {
        Date date = new Date(System.currentTimeMillis());
        File logDir = new File(this.logsQuelle);
        if (logDir.exists()) {
            File[] list = logDir.listFiles();
            int i = 0;
            while (i < list.length) {
                block22: {
                    if (list[i].isDirectory() && !list[i].getName().equals(this.dateFormat.format(date)) && !list[i].getName().equals(this.dateFormatalt.format(date)) && list[i].listFiles().length > 0 && !list[i].getName().equals(this.backupLogs)) {
                        String zipName = String.valueOf(this.logsZiel) + "/" + list[i].getName();
                        ZipOutputStream zos = null;
                        try {
                            File f = new File(String.valueOf(zipName) + ".zip");
                            zos = new ZipOutputStream(new FileOutputStream(f.getCanonicalPath()));
                            if (this.zipDir(zipName, list[i].getCanonicalPath(), list[i], zos)) {
                                zos.flush();
                                zos.closeEntry();
                                zos.close();
                                list[i].delete();
                            }
                        }
                        catch (ZipException ze) {
                            ze.printStackTrace();
                            try {
                                if (zos != null) {
                                    zos.close();
                                }
                                break block22;
                            }
                            catch (IOException iOException) {}
                            break block22;
                        }
                        catch (IOException e) {
                            try {
                                e.printStackTrace();
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (zos != null) {
                                        zos.close();
                                    }
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                            try {
                                if (zos != null) {
                                    zos.close();
                                }
                                break block22;
                            }
                            catch (IOException iOException) {}
                            break block22;
                        }
                        try {
                            if (zos != null) {
                                zos.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                ++i;
            }
        }
    }

    private boolean cleanUpOldLogs() {
        File logDir = new File(this.logsZiel);
        File[] list = logDir.listFiles();
        Arrays.sort(list, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (o1.lastModified() > o2.lastModified()) {
                    return 1;
                }
                if (o1.lastModified() < o2.lastModified()) {
                    return -1;
                }
                return 0;
            }
        });
        int index = 0;
        long actSize = this.getFolderSize(logDir);
        while (actSize > this.maxOrdnerGroesse && index < list.length) {
            if (list[index].isFile() && list[index].getName().endsWith(".zip")) {
                list[index].delete();
                actSize = this.getFolderSize(logDir);
            }
            ++index;
        }
        return true;
    }

    private long getFolderSize(File folder) {
        long size = 0L;
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            size = file.isFile() ? (size += file.length()) : (size += this.getFolderSize(file));
            ++n2;
        }
        return size;
    }

    private boolean zipDir(String zipName, String dirToZip, File dirToZipFile, ZipOutputStream zos) {
        if (zipName == null || dirToZip == null || dirToZipFile == null || zos == null || !dirToZipFile.isDirectory()) {
            return false;
        }
        FileInputStream fis = null;
        try {
            File[] fileArray;
            File[] fileArray2 = fileArray = dirToZipFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray2[n2];
                if (f.isDirectory()) {
                    this.zipDir(zipName, dirToZip, f, zos);
                    this.deleteDirectory(f);
                } else {
                    int len;
                    fis = new FileInputStream(f);
                    String path = f.getCanonicalPath();
                    String name = path.substring(dirToZip.length(), path.length());
                    if (name.substring(0, 1).equals(File.separator)) {
                        name = name.substring(1, name.length());
                    }
                    zos.putNextEntry(new ZipEntry(name));
                    byte[] buffer = new byte[4096];
                    while ((len = fis.read(buffer, 0, buffer.length)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                    fis.close();
                    if (f.isFile()) {
                        f.delete();
                    }
                }
                ++n2;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {
                return false;
            }
            return false;
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {
                    return false;
                }
                throw throwable;
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {
                return false;
            }
            return false;
        }
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private boolean deleteDirectory(File file) {
        if (!file.getName().equals(this.backupLogs)) {
            File[] list;
            if (file.delete()) {
                return true;
            }
            File[] fileArray = list = file.listFiles();
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.deleteDirectory(f);
                ++n2;
            }
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        new BackupLogs();
    }
}

