/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.ttc7.MAREngine;

public class TTIoac
extends DBType {
    public MAREngine meg;
    protected short oacdty;
    protected short oacflg;
    protected short oacpre;
    protected short oacscl;
    protected int oacmxl;
    protected int oacmal;
    protected int oacfl2;
    private boolean oacReadyToUnmarshal = false;

    public TTIoac(int n, MAREngine mAREngine, short s) {
        super(n, s);
        this.meg = mAREngine;
        if (n == 102) {
            this.max_length = 5;
        }
    }

    public TTIoac(MAREngine mAREngine) {
        this.meg = mAREngine;
    }

    public void setFieldsForBinds(int n, int n2) throws SQLException {
        if (n2 <= 0) {
            DBError.check_error(58, new Integer(n2));
        }
        switch (n) {
            case 96: {
                this.max_length = 255;
                break;
            }
            case 1: {
                this.max_length = 2000 / n2;
            }
        }
    }

    public void init(DBType dBType) {
        this.oacdty = (short)dBType.type;
        this.oacmxl = dBType.max_length;
        this.is_stream = dBType.is_stream;
        this.oacReadyToUnmarshal = true;
    }

    public void unmarshal() throws IOException, SQLException {
        this.oacdty = this.meg.unmarshalUB1();
        this.oacflg = this.meg.unmarshalUB1();
        this.oacpre = this.meg.unmarshalUB1();
        this.oacscl = this.oacdty == 2 ? (short)this.meg.unmarshalUB2() : this.meg.unmarshalUB1();
        if ((this.oacdty == 180 || this.oacdty == 181 || this.oacdty == 231 || this.oacdty == 183) && this.oacscl > 0) {
            this.meg.unmarshalUB1();
        }
        this.oacmxl = this.meg.unmarshalSB4();
        this.oacmal = this.meg.unmarshalSB4();
        this.oacfl2 = this.meg.unmarshalSB4();
        switch (this.oacdty) {
            case 2: {
                this.oacmxl = 22;
                break;
            }
            case 12: {
                this.oacmxl = 7;
                break;
            }
            case 181: {
                this.oacmxl = 13;
            }
        }
        if (this.oacdty == 11 || this.oacdty == 208) {
            this.oacdty = (short)104;
        }
    }

    public void marshal() throws IOException, SQLException {
        if (!this.oacReadyToUnmarshal) {
            DBError.check_error(427);
        }
        this.oacflg = 1;
        this.oacpre = 0;
        this.oacscl = 0;
        this.oacmal = 0;
        this.oacfl2 = 0;
        if (this.oacdty == 96) {
            this.oacflg = (short)(this.oacflg | 0x20);
        } else if (this.oacdty == 999) {
            this.oacdty = (short)96;
        }
        if (this.oacdty == 11 || this.oacdty == 104) {
            this.oacdty = 1;
        }
        if (this.meg.types.getVersion() == 7230 && this.oacdty == 24) {
            this.oacdty = (short)23;
        }
        this.meg.marshalUB1(this.oacdty);
        this.meg.marshalUB1(this.oacflg);
        this.meg.marshalUB1(this.oacpre);
        this.meg.marshalUB1(this.oacscl);
        if (this.oacdty == 102) {
            this.meg.marshalSB4(1);
        } else {
            this.meg.marshalUB4(this.oacmxl);
        }
        this.meg.marshalSB4(this.oacmal);
        this.meg.marshalSB4(this.oacfl2);
    }

    public boolean isStream() throws SQLException {
        if (!this.oacReadyToUnmarshal) {
            DBError.check_error(427);
        }
        return this.is_stream;
    }

    public void print(int n, int n2, int n3) {
    }
}

