/*
 * Decompiled with CFR 0.152.
 */
package TestUmgebung;

import TestUmgebung.SpezialRenderer;
import java.awt.Dimension;
import java.awt.Window;
import java.util.Calendar;
import java.util.Date;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class Gant3Demo
extends ApplicationFrame {
    public Gant3Demo(String title) {
        super(title);
        IntervalCategoryDataset dataset = Gant3Demo.createDataset();
        SpezialRenderer sr = new SpezialRenderer(true);
        JFreeChart chart = this.createChart(dataset);
        CategoryPlot cp = chart.getCategoryPlot();
        cp.setRenderer(sr);
        System.out.println("cp: " + cp.toString());
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public static IntervalCategoryDataset createDataset() {
        TaskSeries s1 = new TaskSeries("Offen");
        s1.add(new Task("Offen", new SimpleTimePeriod(Gant3Demo.date(1, 3, 2001), Gant3Demo.date(5, 3, 2001))));
        TaskSeries s2 = new TaskSeries("Geschlossen");
        s2.add(new Task("Geschlossen", new SimpleTimePeriod(Gant3Demo.date(5, 3, 2001), Gant3Demo.date(10, 3, 2001))));
        s1.add(new Task("zwei", new SimpleTimePeriod(Gant3Demo.date(10, 3, 2001), Gant3Demo.date(12, 3, 2001))));
        TaskSeriesCollection collection = new TaskSeriesCollection();
        collection.add(s1);
        collection.add(s2);
        return collection;
    }

    private static Date date(int day, int month, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day);
        Date result = calendar.getTime();
        return result;
    }

    private JFreeChart createChart(IntervalCategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createGanttChart("Gantt Chart Demo", "Task", "Date", dataset, true, true, false, true);
        return chart;
    }

    public static void main(String[] args) {
        Gant3Demo demo = new Gant3Demo("Gantt Chart Demo 1");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)demo));
        demo.setVisible(true);
    }
}

