/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.xpm;

import java.util.logging.Level;

public class Logger {
    protected boolean mfRuntime;
    private static Logger mpInstanceRuntime = null;
    private static Logger mpInstanceAxProtector = null;
    protected java.util.logging.Logger mLogger;

    private Logger(boolean bl) {
        this.mfRuntime = bl;
        this.checkLogger();
        if (null == this.mLogger) {
            System.err.println("Logger could not be created.");
        }
    }

    private boolean checkLogger() {
        if (null == this.mLogger) {
            try {
                this.mLogger = this.mfRuntime ? java.util.logging.Logger.getLogger("com.wibu.xpm.Runtime") : java.util.logging.Logger.getLogger("com.wibu.xpm.AxProtector");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.mLogger != null;
    }

    public static Logger getLogger(boolean bl) {
        if (bl) {
            if (null == mpInstanceRuntime) {
                mpInstanceRuntime = new Logger(bl);
            }
            return mpInstanceRuntime;
        }
        if (null == mpInstanceAxProtector) {
            mpInstanceAxProtector = new Logger(bl);
        }
        return mpInstanceAxProtector;
    }

    public void debug(String string) {
        if (this.checkLogger()) {
            this.mLogger.finest(string);
        }
    }

    public void trace(String string) {
        if (this.checkLogger()) {
            this.mLogger.finer(string);
        }
    }

    public void fine(String string) {
        if (this.checkLogger()) {
            this.mLogger.fine(string);
        }
    }

    public void info(String string) {
        if (this.mfRuntime) {
            if (this.checkLogger()) {
                this.mLogger.info(string);
            }
        } else {
            System.err.println("Info: " + string);
        }
    }

    public void warning(String string) {
        if (this.mfRuntime) {
            if (this.checkLogger()) {
                this.mLogger.warning(string);
            }
        } else {
            System.err.println("Warning: " + string);
        }
    }

    public void error(String string) {
        if (this.mfRuntime) {
            if (this.checkLogger()) {
                this.mLogger.severe(string);
            }
        } else {
            System.err.println("Error: " + string);
        }
    }

    public void fatal(String string) {
        if (this.mfRuntime) {
            if (this.checkLogger()) {
                this.mLogger.severe(string);
            }
        } else {
            System.err.println("Fatal: " + string);
        }
    }

    public int getLevel() {
        if (this.checkLogger()) {
            Level level = this.mLogger.getLevel();
            if (null == level && null == (level = this.mLogger.getParent().getLevel())) {
                return Level.OFF.intValue();
            }
            return level.intValue();
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        Logger.printLevel(Level.ALL);
        Logger.printLevel(Level.CONFIG);
        Logger.printLevel(Level.FINE);
        Logger.printLevel(Level.FINER);
        Logger.printLevel(Level.FINEST);
        Logger.printLevel(Level.INFO);
        Logger.printLevel(Level.OFF);
        Logger.printLevel(Level.SEVERE);
        Logger.printLevel(Level.WARNING);
    }

    private static void printLevel(Level level) {
        System.out.println(level.getName() + " - " + level.intValue());
    }

    public void setLevel(Level level) {
        if (this.checkLogger()) {
            this.mLogger.setLevel(level);
        }
    }

    public boolean isLoggable(Level level) {
        if (this.checkLogger()) {
            return this.mLogger.isLoggable(level);
        }
        return false;
    }

    public static void cleanUp() {
        mpInstanceRuntime = null;
        mpInstanceAxProtector = null;
    }
}

