/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.StructMetaData;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.OracleSQLOutput;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.TypeDescriptor;

public class StructDescriptor
extends TypeDescriptor
implements Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;
    transient Boolean m_isInstanciable = null;
    transient String m_supertype = null;
    transient int m_numLocalAttrs = -1;
    transient String[] m_subtypes = null;
    transient String[] m_attrJavaNames = null;
    final int LOCAL_TYPE = 0;
    final int LOOK_FOR_USER_SYNONYM = 1;
    final int LOOK_FOR_PUBLIC_SYNONYM = 2;
    final String[] initMetaData1_9_0_SQL = new String[]{"SELECT INSTANTIABLE, supertype_owner, supertype_name, LOCAL_ATTRIBUTES FROM all_types WHERE type_name = :1 AND owner = :2 ", "DECLARE \n bind_synonym_name user_synonyms.synonym_name%type := :1; \n the_table_owner  user_synonyms.table_owner%type; \n the_table_name   user_synonyms.table_name%type; \n the_db_link      user_synonyms.db_link%type; \n sql_string       VARCHAR2(1000); \nBEGIN \n   SELECT /*+RULE*/ TABLE_NAME, TABLE_OWNER, DB_LINK INTO  \n         the_table_name, the_table_owner, the_db_link \n         FROM USER_SYNONYMS WHERE \n         SYNONYM_NAME = bind_synonym_name; \n \n   sql_string := 'SELECT /*+RULE*/ INSTANTIABLE, SUPERTYPE_OWNER,      SUPERTYPE_NAME, LOCAL_ATTRIBUTES FROM ALL_TYPES'; \n \n   IF the_db_link IS NOT NULL  \n   THEN \n     sql_string := sql_string || '@' || the_db_link; \n   END IF; \n   sql_string := sql_string       || ' WHERE TYPE_NAME = '''       || the_table_name   || ''' AND OWNER = '''       || the_table_owner  || ''''; \n   OPEN :2 FOR sql_string; \nEND;", "DECLARE \n bind_synonym_name user_synonyms.synonym_name%type := :1; \n the_table_owner  user_synonyms.table_owner%type; \n the_table_name   user_synonyms.table_name%type; \n the_db_link      user_synonyms.db_link%type; \n sql_string       VARCHAR2(1000); \nBEGIN \n   SELECT /*+RULE*/ TABLE_NAME, TABLE_OWNER, DB_LINK INTO  \n         the_table_name, the_table_owner, the_db_link \n         FROM ALL_SYNONYMS WHERE \n         OWNER = 'PUBLIC' AND \n         SYNONYM_NAME = bind_synonym_name; \n \n   sql_string := 'SELECT /*+RULE*/ INSTANTIABLE, SUPERTYPE_OWNER,      SUPERTYPE_NAME, LOCAL_ATTRIBUTES FROM ALL_TYPES'; \n \n   IF the_db_link IS NOT NULL  \n   THEN \n     sql_string := sql_string || '@' || the_db_link; \n   END IF; \n   sql_string := sql_string       || ' WHERE TYPE_NAME = '''       || the_table_name   || ''' AND OWNER = '''       || the_table_owner  || ''''; \n   OPEN :2 FOR sql_string; \nEND;"};

    public static StructDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        SQLName sQLName;
        String string2;
        StructDescriptor structDescriptor;
        if (string == null || string.length() == 0 || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        if ((structDescriptor = (StructDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string2 = (sQLName = new SQLName(string, (oracle.jdbc.OracleConnection)connection)).getName())) == null) {
            structDescriptor = new StructDescriptor(sQLName, connection);
            ((oracle.jdbc.OracleConnection)connection).putDescriptor(string2, structDescriptor);
        }
        return structDescriptor;
    }

    public StructDescriptor(String string, Connection connection) throws SQLException {
        super(string, connection);
        this.initPickler();
    }

    public StructDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super(sQLName, connection);
        this.initPickler();
    }

    public StructDescriptor(SQLName sQLName, OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super(sQLName, oracleTypeADT, connection);
    }

    private void initPickler() throws SQLException {
        try {
            this.m_pickler = new OracleTypeADT(this.getName(), (Connection)this.m_conn);
            ((OracleTypeADT)this.m_pickler).init((OracleConnection)this.m_conn);
            this.m_pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            DBError.throwSqlException(60, "Unable to resolve type \"" + this.getName() + "\"");
        }
    }

    public StructDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super(oracleTypeADT, connection);
    }

    public int getTypeCode() throws SQLException {
        int n = this.m_pickler.getTypeCode();
        return n;
    }

    public int getTypeVersion() throws SQLException {
        int n = this.m_pickler.getTypeVersion();
        return n;
    }

    byte[] toBytes(STRUCT sTRUCT, boolean bl) throws SQLException {
        byte[] byArray = sTRUCT.shareBytes();
        if (byArray == null) {
            if (sTRUCT.m_datumArray != null) {
                byArray = this.m_pickler.linearize(sTRUCT);
                if (!bl) {
                    sTRUCT.setShareBytes(null);
                }
            } else if (sTRUCT.m_objArray != null) {
                sTRUCT.m_datumArray = this.toOracleArray(sTRUCT.m_objArray);
                byArray = this.m_pickler.linearize(sTRUCT);
                if (!bl) {
                    sTRUCT.m_datumArray = null;
                    sTRUCT.setShareBytes(null);
                }
            } else {
                DBError.throwSqlException(1);
            }
        } else if (sTRUCT.m_imgLength != 0L && (sTRUCT.m_imgOffset != 0L || sTRUCT.m_imgLength != (long)byArray.length)) {
            byte[] byArray2 = new byte[(int)sTRUCT.m_imgLength];
            System.arraycopy(byArray, (int)sTRUCT.m_imgOffset, byArray2, 0, (int)sTRUCT.m_imgLength);
            sTRUCT.setImage(byArray2, 0L, 0L);
            byArray = byArray2;
        }
        return byArray;
    }

    Datum[] toOracleArray(STRUCT sTRUCT, boolean bl) throws SQLException {
        Datum[] datumArray = sTRUCT.m_datumArray;
        Datum[] datumArray2 = null;
        if (datumArray == null) {
            if (sTRUCT.m_objArray != null) {
                datumArray = this.toOracleArray(sTRUCT.m_objArray);
            } else if (sTRUCT.shareBytes() != null) {
                if ((sTRUCT.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.m_pickler).isEmbeddedADT()) {
                    this.m_pickler = OracleTypeADT.shallow_clone((OracleTypeADT)this.m_pickler);
                }
                this.m_pickler.unlinearize(sTRUCT.shareBytes(), sTRUCT.m_imgOffset, sTRUCT, 1, null);
                datumArray = sTRUCT.m_datumArray;
                if (!bl) {
                    sTRUCT.m_datumArray = null;
                }
            } else {
                DBError.throwSqlException(1);
            }
        }
        if (bl) {
            sTRUCT.m_datumArray = datumArray;
            datumArray2 = (Datum[])datumArray.clone();
        } else {
            datumArray2 = datumArray;
        }
        return datumArray2;
    }

    Object[] toArray(STRUCT sTRUCT, Map map, boolean bl) throws SQLException {
        Object[] objectArray = null;
        if (sTRUCT.m_objArray == null) {
            if (sTRUCT.m_datumArray != null) {
                objectArray = new Object[sTRUCT.m_datumArray.length];
                int n = 0;
                while (n < sTRUCT.m_datumArray.length) {
                    if (sTRUCT.m_datumArray[n] != null) {
                        objectArray[n] = sTRUCT.m_datumArray[n] instanceof STRUCT ? ((STRUCT)sTRUCT.m_datumArray[n]).toJdbc(map) : sTRUCT.m_datumArray[n].toJdbc();
                    }
                    ++n;
                }
            } else if (sTRUCT.shareBytes() != null) {
                if ((sTRUCT.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.m_pickler).isEmbeddedADT()) {
                    this.m_pickler = OracleTypeADT.shallow_clone((OracleTypeADT)this.m_pickler);
                }
                this.m_pickler.unlinearize(sTRUCT.shareBytes(), sTRUCT.m_imgOffset, sTRUCT, 2, map);
                objectArray = sTRUCT.m_objArray;
                sTRUCT.m_objArray = null;
            } else {
                DBError.throwSqlException(1);
            }
        } else {
            objectArray = (Object[])sTRUCT.m_objArray.clone();
        }
        return objectArray;
    }

    public int getLength() throws SQLException {
        int n = this.getFieldTypes().length;
        return n;
    }

    public OracleTypeADT getOracleTypeADT() {
        OracleTypeADT oracleTypeADT = (OracleTypeADT)this.m_pickler;
        return oracleTypeADT;
    }

    private OracleType[] getFieldTypes() throws SQLException {
        OracleType[] oracleTypeArray = ((OracleTypeADT)this.m_pickler).getAttrTypes();
        return oracleTypeArray;
    }

    public SQLInput toJdbc2SQLInput(STRUCT sTRUCT, Map map) throws SQLException {
        OracleJdbc2SQLInput oracleJdbc2SQLInput = new OracleJdbc2SQLInput(this.toOracleArray(sTRUCT, false), map, this.m_conn);
        return oracleJdbc2SQLInput;
    }

    public SQLOutput toJdbc2SQLOutput() throws SQLException {
        OracleSQLOutput oracleSQLOutput = new OracleSQLOutput(this, this.m_conn);
        return oracleSQLOutput;
    }

    public Datum[] toOracleArray(Object[] objectArray) throws SQLException {
        Datum[] datumArray = null;
        if (objectArray != null) {
            OracleType[] oracleTypeArray = this.getFieldTypes();
            int n = oracleTypeArray.length;
            if (objectArray.length != n) {
                DBError.check_error(49, null);
            }
            datumArray = new Datum[n];
            int n2 = 0;
            while (n2 < n) {
                datumArray[n2] = oracleTypeArray[n2].toDatum(objectArray[n2], (OracleConnection)this.m_conn);
                ++n2;
            }
        }
        return datumArray;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        StructMetaData structMetaData = new StructMetaData(this);
        return structMetaData;
    }

    public boolean isFinalType() throws SQLException {
        boolean bl = this.getOracleTypeADT().isFinalType();
        return bl;
    }

    public boolean isSubtype() throws SQLException {
        boolean bl = this.getOracleTypeADT().isSubType();
        return bl;
    }

    public boolean isInHierarchyOf(String string) throws SQLException {
        StructDescriptor structDescriptor = this;
        String string2 = structDescriptor.getName();
        boolean bl = false;
        if (string.equals(string2)) {
            bl = true;
        } else {
            while (true) {
                if ((string2 = structDescriptor.getSupertypeName()) == null) {
                    bl = false;
                    break;
                }
                if (string.equals(string2)) {
                    bl = true;
                    break;
                }
                structDescriptor = StructDescriptor.createDescriptor(string2, this.m_conn);
            }
        }
        return bl;
    }

    public boolean isInstantiable() throws SQLException {
        if (this.m_isInstanciable == null) {
            this.initMetaData1();
        }
        boolean bl = this.m_isInstanciable;
        return bl;
    }

    public boolean isJavaObject() throws SQLException {
        boolean bl = this.getOracleTypeADT().isJavaObject();
        return bl;
    }

    public String getSupertypeName() throws SQLException {
        String string = null;
        if (this.isSubtype()) {
            if (this.m_supertype == null) {
                this.initMetaData1();
            }
            string = this.m_supertype;
        }
        return string;
    }

    public int getLocalAttributeCount() throws SQLException {
        int n;
        if (!this.isSubtype()) {
            n = this.getOracleTypeADT().getAttrTypes().length;
        } else {
            if (this.m_numLocalAttrs == -1) {
                this.initMetaData1();
            }
            n = this.m_numLocalAttrs;
        }
        return n;
    }

    public String[] getSubtypeNames() throws SQLException {
        if (this.m_subtypes == null) {
            this.initMetaData2();
        }
        return this.m_subtypes;
    }

    public String getJavaClassName() throws SQLException {
        String string = null;
        if (this.isJavaObject()) {
            string = StructDescriptor.getJavaObjectClassName(this.m_conn, this);
        }
        return string;
    }

    public String getAttributeJavaName(int n) throws SQLException {
        String string = null;
        if (this.isJavaObject()) {
            if (this.m_attrJavaNames == null) {
                this.initMetaData3();
            }
            string = this.m_attrJavaNames[n];
        }
        return string;
    }

    public String[] getAttributeJavaNames() throws SQLException {
        String[] stringArray = null;
        if (this.isJavaObject()) {
            if (this.m_attrJavaNames == null) {
                this.initMetaData3();
            }
            stringArray = this.m_attrJavaNames;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String getLanguage() throws SQLException {
        String string = null;
        string = this.isJavaObject() ? "JAVA" : "SQL";
        return string;
    }

    public Class getClass(Map map) throws SQLException {
        String string = this.getName();
        Class clazz = (Class)map.get(string);
        String string2 = this.getSchemaName();
        String string3 = this.getTypeName();
        if (clazz == null && this.m_conn.getUserName().equals(string2)) {
            clazz = (Class)map.get(string3);
        }
        if (SQLName.s_parseAllFormat) {
            if (clazz == null && this.m_conn.getUserName().equals(string2)) {
                clazz = (Class)map.get("\"" + string3 + "\"");
            }
            if (clazz == null) {
                clazz = (Class)map.get("\"" + string2 + "\"" + "." + "\"" + string3 + "\"");
            }
            if (clazz == null) {
                clazz = (Class)map.get("\"" + string2 + "\"" + "." + string3);
            }
            if (clazz == null) {
                clazz = (Class)map.get(string2 + "." + "\"" + string3 + "\"");
            }
        }
        return clazz;
    }

    public static String getJavaObjectClassName(Connection connection, StructDescriptor structDescriptor) throws SQLException {
        String string = StructDescriptor.getJavaObjectClassName(connection, structDescriptor.getSchemaName(), structDescriptor.getTypeName());
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getJavaObjectClassName(Connection connection, String string, String string2) throws SQLException {
        String string3;
        PreparedStatement preparedStatement;
        block10: {
            preparedStatement = null;
            ResultSet resultSet = null;
            string3 = null;
            try {
                try {
                    preparedStatement = connection.prepareStatement("select external_name from all_sqlj_types where owner = ? and type_name = ?");
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string2);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        string3 = resultSet.getString(1);
                    } else {
                        DBError.throwSqlException(100);
                    }
                }
                catch (SQLException sQLException) {
                    Object var8_7 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement == null) return string3;
                    preparedStatement.close();
                    return string3;
                }
                Object var8_6 = null;
                if (resultSet == null) break block10;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement == null) throw throwable;
                preparedStatement.close();
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement == null) return string3;
        preparedStatement.close();
        return string3;
    }

    public String descType() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        return this.descType(stringBuffer, 0);
    }

    String descType(StringBuffer stringBuffer, int n) throws SQLException {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + "  ";
            ++n2;
        }
        String string2 = string + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("Subtype=" + this.getOracleTypeADT().isSubType());
        stringBuffer.append(" JavaObject=" + this.getOracleTypeADT().isJavaObject());
        stringBuffer.append(" FinalType=" + this.getOracleTypeADT().isFinalType());
        stringBuffer.append("\n");
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        int n4 = 0;
        while (n4 < n3) {
            TypeDescriptor typeDescriptor;
            int n5 = resultSetMetaData.getColumnType(n4 + 1);
            if (n5 == 2002 || n5 == 2008) {
                typeDescriptor = StructDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(n4 + 1), this.m_conn);
                ((StructDescriptor)typeDescriptor).descType(stringBuffer, n + 1);
            } else if (n5 == 2003) {
                typeDescriptor = ArrayDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(n4 + 1), this.m_conn);
                ((ArrayDescriptor)typeDescriptor).descType(stringBuffer, n + 1);
            } else if (n5 == 2007) {
                typeDescriptor = OpaqueDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(n4 + 1), this.m_conn);
                ((OpaqueDescriptor)typeDescriptor).descType(stringBuffer, n + 1);
            } else {
                stringBuffer.append(string2);
                stringBuffer.append(resultSetMetaData.getColumnTypeName(n4 + 1));
                stringBuffer.append("\n");
            }
            ++n4;
        }
        String string3 = stringBuffer.toString();
        return string3;
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        Datum[] datumArray = this.toOracleArray(objectArray);
        return this.toBytes(datumArray);
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, (byte[])null, this.m_conn);
        sTRUCT.setDatumArray(datumArray);
        return this.m_pickler.linearize(sTRUCT);
    }

    public Datum[] toArray(Object[] objectArray) throws SQLException {
        return this.toOracleArray(objectArray);
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, byArray, this.m_conn);
        return this.toOracleArray(sTRUCT, false);
    }

    private void initMetaData1() throws SQLException {
        short s = this.m_conn.getVersionNumber();
        if (s >= 9000) {
            this.initMetaData1_9_0();
        } else {
            this.initMetaData1_pre_9_0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData1_9_0() throws SQLException {
        block25: {
            int n = 0;
            oracle.jdbc.internal.OracleConnection oracleConnection = this.m_conn;
            synchronized (oracleConnection) {
                StructDescriptor structDescriptor = this;
                synchronized (structDescriptor) {
                    int n2;
                    OracleCallableStatement oracleCallableStatement;
                    PreparedStatement preparedStatement;
                    block24: {
                        if (this.m_numLocalAttrs != -1) break block25;
                        preparedStatement = null;
                        oracleCallableStatement = null;
                        ResultSet resultSet = null;
                        n2 = -1;
                        try {
                            block14: while (true) {
                                switch (n) {
                                    case 0: {
                                        preparedStatement = this.m_conn.prepareStatement(this.initMetaData1_9_0_SQL[n]);
                                        preparedStatement.setString(1, this.getTypeName());
                                        preparedStatement.setString(2, this.getSchemaName());
                                        resultSet = preparedStatement.executeQuery();
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        try {
                                            oracleCallableStatement = (OracleCallableStatement)this.m_conn.prepareCall(this.initMetaData1_9_0_SQL[n]);
                                            oracleCallableStatement.setString(1, this.getTypeName());
                                            oracleCallableStatement.registerOutParameter(2, -10);
                                            oracleCallableStatement.execute();
                                            resultSet = oracleCallableStatement.getCursor(2);
                                            break;
                                        }
                                        catch (SQLException sQLException) {
                                            if (sQLException.getErrorCode() == 1403) {
                                                if (n == 1) {
                                                    oracleCallableStatement.close();
                                                    ++n;
                                                    continue block14;
                                                }
                                                DBError.throwSqlException(1, "Inconsistent catalog view");
                                                break;
                                            }
                                            throw sQLException;
                                        }
                                    }
                                }
                                if (resultSet.next()) break;
                                if (n == 2) {
                                    DBError.throwSqlException(1, "Inconsistent catalog view");
                                    continue;
                                }
                                resultSet.close();
                                if (oracleCallableStatement != null) {
                                    oracleCallableStatement.close();
                                }
                                ++n;
                            }
                            this.m_isInstanciable = new Boolean(resultSet.getString(1).equals("YES"));
                            this.m_supertype = resultSet.getString(2) + "." + resultSet.getString(3);
                            n2 = resultSet.getInt(4);
                            Object var10_9 = null;
                            if (resultSet == null) break block24;
                        }
                        catch (Throwable throwable) {
                            Object var10_10 = null;
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                            if (oracleCallableStatement != null) {
                                oracleCallableStatement.close();
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (oracleCallableStatement != null) {
                        oracleCallableStatement.close();
                    }
                    this.m_numLocalAttrs = n2;
                }
            }
        }
    }

    private synchronized void initMetaData1_pre_9_0() throws SQLException {
        this.m_isInstanciable = new Boolean(true);
        this.m_supertype = "";
        this.m_numLocalAttrs = 0;
    }

    private void initMetaData2() throws SQLException {
        short s = this.m_conn.getVersionNumber();
        if (s >= 9000) {
            this.initMetaData2_9_0();
        } else {
            this.initMetaData2_pre_9_0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData2_9_0() throws SQLException {
        block14: {
            oracle.jdbc.internal.OracleConnection oracleConnection = this.m_conn;
            synchronized (oracleConnection) {
                StructDescriptor structDescriptor = this;
                synchronized (structDescriptor) {
                    String[] stringArray;
                    PreparedStatement preparedStatement;
                    block13: {
                        if (this.m_subtypes != null) break block14;
                        preparedStatement = null;
                        ResultSet resultSet = null;
                        stringArray = null;
                        try {
                            preparedStatement = this.m_conn.prepareStatement("select owner, type_name from all_types where supertype_name = ? and supertype_owner = ?");
                            preparedStatement.setString(1, this.getTypeName());
                            preparedStatement.setString(2, this.getSchemaName());
                            resultSet = preparedStatement.executeQuery();
                            Vector<String> vector = new Vector<String>();
                            while (resultSet.next()) {
                                vector.addElement(resultSet.getString(1) + "." + resultSet.getString(2));
                            }
                            stringArray = new String[vector.size()];
                            int n = 0;
                            while (n < stringArray.length) {
                                stringArray[n] = (String)vector.elementAt(n);
                                ++n;
                            }
                            vector.removeAllElements();
                            vector = null;
                            Object var9_8 = null;
                            if (resultSet == null) break block13;
                        }
                        catch (Throwable throwable) {
                            Object var9_9 = null;
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    this.m_subtypes = stringArray;
                }
            }
        }
    }

    private void initMetaData2_pre_9_0() throws SQLException {
        this.m_subtypes = new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData3() throws SQLException {
        block13: {
            oracle.jdbc.internal.OracleConnection oracleConnection = this.m_conn;
            synchronized (oracleConnection) {
                StructDescriptor structDescriptor = this;
                synchronized (structDescriptor) {
                    PreparedStatement preparedStatement;
                    String[] stringArray;
                    block12: {
                        if (this.m_attrJavaNames != null) break block13;
                        stringArray = null;
                        preparedStatement = null;
                        ResultSet resultSet = null;
                        try {
                            preparedStatement = this.m_conn.prepareStatement("select EXTERNAL_ATTR_NAME from all_sqlj_type_attrs where owner = ? and type_name = ?");
                            preparedStatement.setString(1, this.getSchemaName());
                            preparedStatement.setString(2, this.getTypeName());
                            resultSet = preparedStatement.executeQuery();
                            stringArray = new String[this.getOracleTypeADT().getAttrTypes().length];
                            int n = 0;
                            while (resultSet.next()) {
                                stringArray[n] = resultSet.getString(1);
                                ++n;
                            }
                            Object var8_7 = null;
                            if (resultSet == null) break block12;
                        }
                        catch (Throwable throwable) {
                            Object var8_8 = null;
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    this.m_attrJavaNames = stringArray;
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

