/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.components;

import de.bsc.bapfinder.BAPFinder;
import de.bsc.bapfinder.components.JWizardHeader;
import de.bsc.bapfinder.components.PasswordField;
import de.bsc.bapfinder.localization.Messages;
import de.bsc.bapfinder.tools.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class PasswordDialog
extends JDialog {
    private static final long serialVersionUID = -6791895695459795436L;
    private static String password;
    private JPanel contentPane;
    private JPanel panelPassword;
    private JPanel panelButtons;
    private JButton buttonOk;
    private JButton buttonCancel;
    private JWizardHeader wizardHeader;
    private PasswordField passwordField;
    private PasswordField passwordFieldNew;
    private PasswordField passwordFieldConfirm;
    private boolean newPasswd;
    private String oldPassword;
    private int currX;
    private int currY;
    private String text;
    private Font font = new Font("Tahoma", 0, 11);

    private PasswordDialog(Window owner, String text, String oldPassword, boolean newPasswd) {
        super(owner);
        this.oldPassword = oldPassword;
        this.newPasswd = newPasswd;
        if (text == null || text.length() == 0) {
            text = Messages.getString("PasswortDialog.Enter");
        }
        this.text = text;
        this.setUndecorated(true);
        this.setIconImage(BAPFinder.loadImage("bapkl.png"));
        this.setModal(true);
        this.initialize();
        this.setMinimumSize(new Dimension(300, 0));
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setDefaultCloseOperation(0);
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
    }

    private Container getJContentPane() {
        if (this.contentPane == null) {
            GridBagConstraints constraintsWizardHeader = new GridBagConstraints();
            constraintsWizardHeader.gridx = 0;
            constraintsWizardHeader.fill = 2;
            constraintsWizardHeader.gridy = 0;
            GridBagConstraints constraintsPasswordPanel = new GridBagConstraints();
            constraintsPasswordPanel.fill = 1;
            constraintsPasswordPanel.gridy = 1;
            constraintsPasswordPanel.weightx = 1.0;
            constraintsPasswordPanel.weighty = 1.0;
            GridBagConstraints constraintsPanelButtons = new GridBagConstraints();
            constraintsPanelButtons.fill = 2;
            constraintsPanelButtons.gridy = 2;
            this.contentPane = new JPanel();
            this.contentPane.setLayout(new GridBagLayout());
            this.contentPane.setBorder(BorderFactory.createEtchedBorder(0));
            this.contentPane.add((Component)this.getWizardHeader(), constraintsWizardHeader);
            this.contentPane.add(this.getPasswordPanel(), constraintsPasswordPanel);
            this.contentPane.add((Component)this.getPanelButtons(), constraintsPanelButtons);
        }
        return this.contentPane;
    }

    private JWizardHeader getWizardHeader() {
        if (this.wizardHeader == null) {
            this.wizardHeader = new JWizardHeader();
            this.wizardHeader.setImage(BAPFinder.loadImage("activation.png"));
            this.wizardHeader.setTextHeader1(Messages.getString("PasswortDialog.Passwort"));
            this.wizardHeader.setTextHeader2(this.text);
            this.wizardHeader.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (e.getModifiersEx() != 1024) {
                        return;
                    }
                    PasswordDialog.this.setLocation(e.getXOnScreen() - PasswordDialog.this.currX, e.getYOnScreen() - PasswordDialog.this.currY);
                }
            });
            this.wizardHeader.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    PasswordDialog.this.currX = e.getX();
                    PasswordDialog.this.currY = e.getY();
                }
            });
        }
        return this.wizardHeader;
    }

    private Component getPasswordPanel() {
        if (this.panelPassword == null) {
            GridBagConstraints constraintsPasswordField = new GridBagConstraints();
            constraintsPasswordField.fill = 2;
            constraintsPasswordField.gridy = 0;
            constraintsPasswordField.weightx = 1.0;
            GridBagConstraints constraintsPasswordFieldNew = new GridBagConstraints();
            constraintsPasswordFieldNew.fill = 2;
            constraintsPasswordFieldNew.gridy = 1;
            constraintsPasswordFieldNew.weightx = 1.0;
            GridBagConstraints constraintsPasswordFieldConfirm = new GridBagConstraints();
            constraintsPasswordFieldConfirm.fill = 2;
            constraintsPasswordFieldConfirm.gridy = 2;
            constraintsPasswordFieldConfirm.weightx = 1.0;
            this.panelPassword = new JPanel();
            this.panelPassword.setLayout(new GridBagLayout());
            this.panelPassword.setBorder(new EtchedBorder(1));
            if (this.oldPassword != null) {
                this.panelPassword.add(this.getPasswordField(), constraintsPasswordField);
            }
            if (this.newPasswd) {
                this.panelPassword.add(this.getPasswordFieldNew(), constraintsPasswordFieldNew);
                this.panelPassword.add(this.getPasswordFieldConfirm(), constraintsPasswordFieldConfirm);
            }
        }
        return this.panelPassword;
    }

    private Component getPasswordField() {
        if (this.passwordField == null) {
            this.passwordField = new PasswordField(Messages.getString("PasswortDialog.AktuellesPasswort"));
            this.passwordField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PasswordDialog.this.newPasswd) {
                        PasswordDialog.this.passwordField.transferFocus();
                    } else {
                        PasswordDialog.this.buttonOk.doClick();
                    }
                }
            });
        }
        return this.passwordField;
    }

    private Component getPasswordFieldNew() {
        if (this.passwordFieldNew == null) {
            this.passwordFieldNew = new PasswordField(Messages.getString("PasswortDialog.NeuesPasswort"));
            this.passwordFieldNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PasswordDialog.this.passwordFieldNew.transferFocus();
                }
            });
        }
        return this.passwordFieldNew;
    }

    private Component getPasswordFieldConfirm() {
        if (this.passwordFieldConfirm == null) {
            this.passwordFieldConfirm = new PasswordField(Messages.getString("PasswortDialog.NeuesPasswortWiederholen"));
            this.passwordFieldConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PasswordDialog.this.buttonOk.doClick();
                }
            });
        }
        return this.passwordFieldConfirm;
    }

    private JPanel getPanelButtons() {
        if (this.panelButtons == null) {
            GridBagConstraints constraintsButtonSave = new GridBagConstraints();
            constraintsButtonSave.gridx = 0;
            constraintsButtonSave.insets = new Insets(5, 5, 5, 5);
            constraintsButtonSave.fill = 0;
            constraintsButtonSave.anchor = 13;
            constraintsButtonSave.weightx = 1.0;
            constraintsButtonSave.gridy = 0;
            GridBagConstraints constraintsButtonClose = new GridBagConstraints();
            constraintsButtonClose.gridx = 1;
            constraintsButtonClose.insets = new Insets(5, 0, 5, 5);
            constraintsButtonClose.anchor = 13;
            constraintsButtonClose.weightx = 0.0;
            constraintsButtonClose.gridy = 0;
            this.panelButtons = new JPanel();
            this.panelButtons.setLayout(new GridBagLayout());
            this.panelButtons.setBorder(BorderFactory.createEtchedBorder(1));
            this.panelButtons.add((Component)this.getButtonOk(), constraintsButtonSave);
            this.panelButtons.add((Component)this.getButtonCancel(), constraintsButtonClose);
        }
        return this.panelButtons;
    }

    private JButton getButtonOk() {
        if (this.buttonOk == null) {
            this.buttonOk = new JButton();
            this.buttonOk.setText(Messages.getString("Ok"));
            this.buttonOk.setIcon(new ImageIcon(BAPFinder.loadImage("learnfunc.png")));
            this.buttonOk.setFont(this.font);
            this.buttonOk.setPreferredSize(new Dimension(100, 30));
            this.buttonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    char[] data = null;
                    char[] data1 = null;
                    char[] data2 = null;
                    if (PasswordDialog.this.oldPassword != null && !PasswordDialog.this.newPasswd) {
                        try {
                            data = PasswordDialog.this.passwordField.getPassword();
                        }
                        catch (Exception exception) {}
                        if (data == null) {
                            Tools.flash(PasswordDialog.this.passwordField, Color.RED, 2);
                            return;
                        }
                        password = new String(data);
                        PasswordDialog.this.dispose();
                    } else if (PasswordDialog.this.oldPassword == null && PasswordDialog.this.newPasswd) {
                        try {
                            data1 = PasswordDialog.this.passwordFieldNew.getPassword();
                        }
                        catch (Exception exception) {}
                        try {
                            data2 = PasswordDialog.this.passwordFieldConfirm.getPassword();
                        }
                        catch (Exception exception) {}
                        if (data1 == null) {
                            Tools.flash(PasswordDialog.this.passwordFieldNew, Color.RED, 2);
                        }
                        if (data2 == null) {
                            Tools.flash(PasswordDialog.this.passwordFieldConfirm, Color.RED, 2);
                        }
                        if (data1 == null || data2 == null) {
                            return;
                        }
                        String pass1 = new String(data1);
                        String pass2 = new String(data2);
                        if (!pass1.equals(pass2)) {
                            Tools.flash(PasswordDialog.this.passwordFieldNew, Color.GREEN, 2);
                            Tools.flash(PasswordDialog.this.passwordFieldConfirm, Color.RED, 2);
                            return;
                        }
                        password = pass1;
                        PasswordDialog.this.dispose();
                    } else {
                        try {
                            data = PasswordDialog.this.passwordField.getPassword();
                        }
                        catch (Exception exception) {}
                        try {
                            data1 = PasswordDialog.this.passwordFieldNew.getPassword();
                        }
                        catch (Exception exception) {}
                        try {
                            data2 = PasswordDialog.this.passwordFieldConfirm.getPassword();
                        }
                        catch (Exception exception) {}
                        if (data == null) {
                            Tools.flash(PasswordDialog.this.passwordField, Color.RED, 2);
                            return;
                        }
                        if (data1 == null) {
                            Tools.flash(PasswordDialog.this.passwordFieldNew, Color.RED, 2);
                        }
                        if (data2 == null) {
                            Tools.flash(PasswordDialog.this.passwordFieldConfirm, Color.RED, 2);
                        }
                        if (data1 == null || data2 == null) {
                            return;
                        }
                        String pass = new String(data);
                        if (!pass.equals(PasswordDialog.this.oldPassword)) {
                            Tools.flash(PasswordDialog.this.passwordField, Color.RED, 2);
                            return;
                        }
                        String pass1 = new String(data1);
                        String pass2 = new String(data2);
                        if (!pass1.equals(pass2)) {
                            Tools.flash(PasswordDialog.this.passwordFieldNew, Color.GREEN, 2);
                            Tools.flash(PasswordDialog.this.passwordFieldConfirm, Color.RED, 2);
                            return;
                        }
                        password = pass1;
                        PasswordDialog.this.dispose();
                    }
                }
            });
        }
        return this.buttonOk;
    }

    private JButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new JButton();
            this.buttonCancel.setText(Messages.getString("Abbruch"));
            this.buttonCancel.setIcon(new ImageIcon(BAPFinder.loadImage("exitkl.png")));
            this.buttonCancel.setFont(this.font);
            this.buttonCancel.setPreferredSize(new Dimension(100, 30));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PasswordDialog.this.oldPassword = null;
                    password = null;
                    PasswordDialog.this.dispose();
                }
            });
        }
        return this.buttonCancel;
    }

    public static String getNewPassword(Window owner) {
        return PasswordDialog.getNewPassword(owner, null);
    }

    public static String getNewPassword(Window owner, String text) {
        PasswordDialog passwordDialog = new PasswordDialog(owner, text, null, true);
        passwordDialog.setVisible(true);
        return password;
    }

    public static String getNewForOldPassword(Window owner, String oldPassword) {
        return PasswordDialog.getNewForOldPassword(owner, null, oldPassword);
    }

    public static String getNewForOldPassword(Window owner, String text, String oldPassword) {
        boolean newPassword = true;
        if (oldPassword == null || oldPassword.length() == 0) {
            oldPassword = "";
            newPassword = false;
        }
        PasswordDialog passwordDialog = new PasswordDialog(owner, text, oldPassword, newPassword);
        passwordDialog.setVisible(true);
        return password;
    }

    public static String getPassword(Window owner) {
        return PasswordDialog.getPassword(owner, null);
    }

    public static String getPassword(Window owner, String text) {
        PasswordDialog passwordDialog = new PasswordDialog(owner, text, "", false);
        passwordDialog.setVisible(true);
        return password;
    }
}

