/*
 * Decompiled with CFR 0.152.
 */
package de.bsc.bapfinder.tools.classloader;

import java.util.Hashtable;

public abstract class MultiClassLoader
extends ClassLoader {
    private Hashtable<String, Class<?>> classes = new Hashtable();
    protected boolean monitorOn = false;
    protected boolean sourceMonitorOn = false;

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    @Override
    public synchronized Class<?> loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        this.monitor(">> MultiClassLoader.loadClass(" + className + ", " + resolveIt + ")");
        Class<?> result = this.classes.get(className);
        if (result != null) {
            this.monitor(">> returning cached result.");
            return result;
        }
        byte[] classBytes = this.loadClassBytes(className);
        if (classBytes == null) {
            try {
                result = super.findSystemClass(className);
                this.monitor(">> returning system class (in CLASSPATH).");
                return result;
            }
            catch (ClassNotFoundException e) {
                this.monitor(">> Not a system class.");
                throw new ClassNotFoundException();
            }
        }
        try {
            result = this.defineClass(className, classBytes, 0, classBytes.length);
        }
        catch (Throwable e) {
            throw new ClassFormatError();
        }
        if (result == null) {
            throw new ClassFormatError();
        }
        if (resolveIt) {
            this.resolveClass(result);
        }
        this.classes.put(className, result);
        this.monitor(">> Returning newly loaded class.");
        return result;
    }

    protected abstract byte[] loadClassBytes(String var1);

    protected String formatClassName(String className) {
        return className;
    }

    protected void monitor(String text) {
        if (this.monitorOn) {
            MultiClassLoader.print(text);
        }
    }

    protected static void print(String text) {
        System.out.println(text);
    }
}

