/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.common.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class RestrictingIterator<S, T>
implements Iterator<T> {
    private Iterator<S> it;
    private Conversion<S, T> conversion;
    private T next = null;

    public RestrictingIterator(Iterator<S> iterator, Conversion<S, T> conversion) {
        this.it = iterator;
        if (iterator == null) {
            throw new NullPointerException();
        }
        this.conversion = conversion;
        if (conversion == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public boolean hasNext() {
        this.locateNext();
        return this.next != null;
    }

    @Override
    public T next() {
        this.locateNext();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        T t = this.next;
        this.next = null;
        return t;
    }

    private void locateNext() {
        while (this.next == null && this.it.hasNext()) {
            S s = this.it.next();
            T t = this.conversion.convert(s);
            if (t == null) continue;
            this.next = t;
            break;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported for ConvertingIterator");
    }

    public static interface Conversion<S, T> {
        public T convert(S var1);
    }
}

